/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import pl.skidam.automodpack_core.protocol.netty.message.request.EchoMessage;
import pl.skidam.automodpack_core.protocol.netty.message.request.FileRequestMessage;
import pl.skidam.automodpack_core.protocol.netty.message.request.FileResponseMessage;
import pl.skidam.automodpack_core.protocol.netty.message.request.RefreshRequestMessage;

public class ProtocolMessageDecoder
extends ByteToMessageDecoder {
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        in.markReaderIndex();
        byte version = in.readByte();
        byte type = in.readByte();
        byte[] secret = new byte[32];
        in.readBytes(secret);
        switch (type) {
            case 0: {
                int dataLength = in.readInt();
                byte[] data = new byte[dataLength];
                in.readBytes(data);
                out.add(new EchoMessage(version, secret, data));
                break;
            }
            case 1: {
                int fileHashLength = in.readInt();
                byte[] fileHash = new byte[fileHashLength];
                in.readBytes(fileHash);
                out.add(new FileRequestMessage(version, secret, fileHash));
                break;
            }
            case 2: {
                int fileLength = in.readInt();
                byte[] fileData = new byte[fileLength];
                in.readBytes(fileData);
                out.add(new FileResponseMessage(version, secret, fileData));
                break;
            }
            case 3: {
                int fileHashesCount = in.readInt();
                int fileHashesLength = in.readInt();
                byte[][] fileHashesList = new byte[fileHashesCount][];
                for (int i = 0; i < fileHashesCount; ++i) {
                    byte[] fileHashEntry = new byte[fileHashesLength];
                    in.readBytes(fileHashEntry);
                    fileHashesList[i] = fileHashEntry;
                }
                out.add(new RefreshRequestMessage(version, secret, fileHashesList));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown message type: " + type);
            }
        }
    }
}

