/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import amp_libs.org.tomlj.Toml;
import amp_libs.org.tomlj.TomlArray;
import amp_libs.org.tomlj.TomlParseResult;
import amp_libs.org.tomlj.TomlTable;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.loader.LoaderManagerService;
import pl.skidam.automodpack_core.utils.CustomFileUtils;

public class FileInspection {
    private static final Gson GSON = new Gson();
    private static final String LOADER = GlobalVariables.LOADER;
    private static final Map<HashPathPair, Mod> modCache = new HashMap<HashPathPair, Mod>();
    private static final Set<String> services = Set.of("META-INF/services/net.minecraftforge.forgespi.locating.IModLocator", "META-INF/services/net.minecraftforge.forgespi.locating.IDependencyLocator", "META-INF/services/net.minecraftforge.forgespi.language.IModLanguageProvider", "META-INF/services/net.neoforged.neoforgespi.locating.IModLocator", "META-INF/services/net.neoforged.neoforgespi.locating.IDependencyLocator", "META-INF/services/net.neoforged.neoforgespi.locating.IModLanguageLoader", "META-INF/services/net.neoforged.neoforgespi.locating.IModFileCandidateLocator", "META-INF/services/net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper");
    private static final String forbiddenChars = "\\/:*\"<>|!?&%$;=+";

    public static boolean isMod(Path file) {
        boolean bl;
        block9: {
            if (!file.getFileName().toString().endsWith(".jar") || !Files.exists(file, new LinkOption[0])) {
                return false;
            }
            FileSystem fs = FileSystems.newFileSystem(file);
            try {
                boolean bl2 = bl = FileInspection.getModID(fs) != null || FileInspection.hasSpecificServices(fs);
                if (fs == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            fs.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Mod getMod(Path file) {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return null;
        }
        if (!file.getFileName().toString().endsWith(".jar")) {
            return null;
        }
        String hash = CustomFileUtils.getHash(file);
        if (hash == null) {
            GlobalVariables.LOGGER.error("Failed to get hash for file: {}", (Object)file);
            return null;
        }
        HashPathPair hashPathPair = new HashPathPair(hash, file);
        if (modCache.containsKey(hashPathPair)) {
            return modCache.get(hashPathPair);
        }
        for (Mod mod2 : GlobalVariables.LOADER_MANAGER.getModList()) {
            if (!hash.equals(mod2.hash)) continue;
            modCache.put(hashPathPair, mod2);
            return mod2;
        }
        try (FileSystem fs = FileSystems.newFileSystem(file);){
            String modId = (String)FileInspection.getModInfo(fs, "modId");
            if (modId == null) return null;
            String modVersion = (String)FileInspection.getModInfo(fs, "version");
            LoaderManagerService.EnvironmentType environmentType = (LoaderManagerService.EnvironmentType)((Object)FileInspection.getModInfo(fs, "environment"));
            Set<String> dependencies = FileInspection.getModDependencies(fs);
            Set<String> providesIDs = FileInspection.getProvidedIDs(fs);
            if (modVersion != null && dependencies != null) {
                Mod mod3 = new Mod(modId, hash, providesIDs, modVersion, file, environmentType, dependencies);
                modCache.put(hashPathPair, mod3);
                Mod mod = mod3;
                return mod;
            }
            GlobalVariables.LOGGER.error("Not enough mod information for file: {} modId: {}, modVersion: {}, dependencies: {}", (Object)file, (Object)modId, (Object)modVersion, dependencies);
            return null;
        }
        catch (IOException e) {
            GlobalVariables.LOGGER.debug("Failed to get mod info for file: {}", (Object)file);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isModCompatible(Path file) {
        if (!file.getFileName().toString().endsWith(".jar")) return false;
        if (!Files.exists(file, new LinkOption[0])) {
            return false;
        }
        try (FileSystem fs = FileSystems.newFileSystem(file);){
            String entryPathString;
            switch (LOADER) {
                case "neoforge": {
                    String string = "META-INF/neoforge.mods.toml";
                    break;
                }
                case "fabric": {
                    String string = "fabric.mod.json";
                    break;
                }
                case "forge": {
                    String string = "META-INF/mods.toml";
                    break;
                }
                case "quilt": {
                    String string = "quilt.mod.json";
                    break;
                }
                default: {
                    String string = entryPathString = null;
                }
            }
            if (entryPathString != null && Files.exists(fs.getPath(entryPathString, new String[0]), new LinkOption[0])) {
                boolean bl = true;
                return bl;
            }
            if (!"forge".equals(LOADER)) {
                if (!"neoforge".equals(LOADER)) return false;
            }
            if (!FileInspection.hasSpecificServices(fs)) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean hasSpecificServices(Path file) {
        boolean bl;
        block9: {
            if (!file.getFileName().toString().endsWith(".jar") || !Files.exists(file, new LinkOption[0])) {
                return false;
            }
            FileSystem fs = FileSystems.newFileSystem(file);
            try {
                bl = FileInspection.hasSpecificServices(fs);
                if (fs == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    GlobalVariables.LOGGER.error("Error reading file {}: {}", (Object)file, (Object)e.getMessage());
                    return false;
                }
            }
            fs.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasSpecificServices(FileSystem fs) {
        for (String service : services) {
            if (!Files.exists(fs.getPath(service, new String[0]), new LinkOption[0])) continue;
            return true;
        }
        Path jarJarDir = fs.getPath("META-INF", "jarjar");
        if (!Files.exists(jarJarDir, new LinkOption[0])) {
            return false;
        }
        try (Stream<Path> walk = Files.walk(jarJarDir, 1, new FileVisitOption[0]);){
            Iterator<Path> iterator = walk.toList().iterator();
            while (iterator.hasNext()) {
                ZipInputStream zipInputStream;
                block27: {
                    Path nestedJarPath = iterator.next();
                    if (nestedJarPath.equals(jarJarDir) || !nestedJarPath.toString().endsWith(".jar")) continue;
                    try {
                        boolean bl;
                        InputStream inputStream;
                        block26: {
                            inputStream = Files.newInputStream(nestedJarPath, new OpenOption[0]);
                            zipInputStream = new ZipInputStream(inputStream);
                            try {
                                ZipEntry nestedEntry;
                                while ((nestedEntry = zipInputStream.getNextEntry()) != null) {
                                    if (!services.contains(nestedEntry.getName())) continue;
                                    bl = true;
                                    break block26;
                                }
                                break block27;
                            }
                            catch (Throwable throwable) {
                                try {
                                    zipInputStream.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        zipInputStream.close();
                        if (inputStream == null) return bl;
                        inputStream.close();
                        return bl;
                    }
                    catch (IOException e) {
                        GlobalVariables.LOGGER.error("Error reading nested JAR in {}: {}", (Object)nestedJarPath, (Object)e.getMessage());
                    }
                }
                zipInputStream.close();
            }
            return false;
        }
        catch (IOException e) {
            GlobalVariables.LOGGER.error("Error examining JarJar in {}", (Object)fs, (Object)e);
        }
        return false;
    }

    public static Path getMetadataPath(FileSystem fs) {
        String[] fallbackEntries;
        Path path;
        String preferredEntry;
        switch (LOADER) {
            case "neoforge": {
                String string = "META-INF/neoforge.mods.toml";
                break;
            }
            case "fabric": {
                String string = "fabric.mod.json";
                break;
            }
            case "forge": {
                String string = "META-INF/mods.toml";
                break;
            }
            case "quilt": {
                String string = "quilt.mod.json";
                break;
            }
            default: {
                String string = preferredEntry = null;
            }
        }
        if (preferredEntry != null && Files.exists(path = fs.getPath(preferredEntry, new String[0]), new LinkOption[0])) {
            return path;
        }
        for (String entryName : fallbackEntries = new String[]{"META-INF/neoforge.mods.toml", "fabric.mod.json", "META-INF/mods.toml", "quilt.mod.json"}) {
            Path path2;
            if (entryName.equals(preferredEntry) || !Files.exists(path2 = fs.getPath(entryName, new String[0]), new LinkOption[0])) continue;
            return path2;
        }
        return null;
    }

    public static String getModVersion(Path file) {
        return (String)FileInspection.getModInfo(file, "version");
    }

    public static String getModID(Path file) {
        return (String)FileInspection.getModInfo(file, "modId");
    }

    public static LoaderManagerService.EnvironmentType getModEnvironment(Path file) {
        return (LoaderManagerService.EnvironmentType)((Object)FileInspection.getModInfo(file, "environment"));
    }

    private static String getModID(FileSystem fs) {
        return (String)FileInspection.getModInfo(fs, "modId");
    }

    private static Set<String> getProvidedIDs(FileSystem fs) {
        return (Set)FileInspection.getModInfo(fs, "provides");
    }

    private static Set<String> getModDependencies(FileSystem fs) {
        return (Set)FileInspection.getModInfo(fs, "dependencies");
    }

    private static boolean isBasicInfo(String infoType) {
        return "version".equals(infoType) || "modId".equals(infoType) || "environment".equals(infoType);
    }

    private static Object getModInfo(Path file, String infoType) {
        Object object;
        block9: {
            if (!file.getFileName().toString().endsWith(".jar") || !Files.exists(file, new LinkOption[0])) {
                return FileInspection.isBasicInfo(infoType) ? null : Set.of();
            }
            FileSystem fs = FileSystems.newFileSystem(file);
            try {
                object = FileInspection.getModInfo(fs, infoType);
                if (fs == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    GlobalVariables.LOGGER.error("Error reading mod file {}: {}", (Object)file, (Object)e.getMessage());
                    return FileInspection.isBasicInfo(infoType) ? null : Set.of();
                }
            }
            fs.close();
        }
        return object;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Object getModInfo(FileSystem fs, String infoType) {
        Path metadataPath = FileInspection.getMetadataPath(fs);
        if (metadataPath == null || !Files.exists(metadataPath, new LinkOption[0])) {
            return FileInspection.isBasicInfo(infoType) ? null : Set.of();
        }
        try (InputStream stream = Files.newInputStream(metadataPath, new OpenOption[0]);){
            BufferedReader reader;
            block16: {
                Object object;
                reader = new BufferedReader(new InputStreamReader(stream));
                try {
                    if (!metadataPath.getFileName().toString().endsWith("mods.toml")) break block16;
                    object = FileInspection.getModInfoFromToml(reader, infoType);
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                reader.close();
                return object;
            }
            Object object = FileInspection.getModInfoFromJson(reader, infoType);
            reader.close();
            return object;
        }
        catch (IOException e) {
            GlobalVariables.LOGGER.error("Error reading metadata {}: {}", (Object)metadataPath, (Object)e.getMessage());
            return FileInspection.isBasicInfo(infoType) ? null : Set.of();
        }
    }

    private static Object getModInfoFromToml(BufferedReader reader, String infoType) {
        try {
            TomlParseResult result = Toml.parse(reader);
            result.errors().forEach(error -> GlobalVariables.LOGGER.error(error.toString()));
            TomlArray modsArray = result.getArray("mods");
            if (modsArray == null) {
                return FileInspection.isBasicInfo(infoType) ? null : Set.of();
            }
            switch (infoType) {
                case "version": {
                    String modVersion = null;
                    for (Object o : modsArray.toList()) {
                        TomlTable tomlTable = (TomlTable)o;
                        if (tomlTable == null) continue;
                        modVersion = tomlTable.getString("version");
                    }
                    return modVersion != null ? modVersion : "1";
                }
                case "modId": {
                    String modID = null;
                    for (Object o : modsArray.toList()) {
                        TomlTable tomlTable = (TomlTable)o;
                        if (tomlTable == null) continue;
                        modID = tomlTable.getString("modId");
                    }
                    return modID;
                }
                case "provides": {
                    HashSet<String> providedIDs = new HashSet<String>();
                    for (Object o : modsArray.toList()) {
                        TomlArray providesArray;
                        TomlTable tomlTable = (TomlTable)o;
                        if (tomlTable == null || (providesArray = tomlTable.getArray("provides")) == null) continue;
                        for (int j = 0; j < providesArray.size(); ++j) {
                            String id = providesArray.getString(j);
                            if (id == null || id.isEmpty()) continue;
                            providedIDs.add(id);
                        }
                    }
                    return providedIDs;
                }
                case "dependencies": {
                    HashSet<String> dependencies = new HashSet<String>();
                    String modID = null;
                    for (Object object : modsArray.toList()) {
                        TomlTable mod = (TomlTable)object;
                        if (mod == null) continue;
                        modID = mod.getString("modId");
                    }
                    if (modID == null) {
                        return dependencies;
                    }
                    TomlArray dependenciesArray = result.getArray("dependencies.\"" + modID + "\"");
                    if (dependenciesArray == null) {
                        return dependencies;
                    }
                    for (Object o : dependenciesArray.toList()) {
                        String depId;
                        TomlTable mod = (TomlTable)o;
                        if (mod == null || (depId = mod.getString("modId")) == null) continue;
                        dependencies.add(depId);
                    }
                    return dependencies;
                }
                case "environment": {
                    LoaderManagerService.EnvironmentType environment = LoaderManagerService.EnvironmentType.UNIVERSAL;
                    String modID = null;
                    for (Object object : modsArray.toList()) {
                        TomlTable mod = (TomlTable)object;
                        if (mod == null) continue;
                        modID = mod.getString("modId");
                    }
                    if (modID == null) {
                        return environment;
                    }
                    TomlArray dependenciesArray = result.getArray("dependencies.\"" + modID + "\"");
                    if (dependenciesArray == null) {
                        return environment;
                    }
                    for (Object o : dependenciesArray.toList()) {
                        String depEnv;
                        String depId;
                        TomlTable mod = (TomlTable)o;
                        if (mod == null || (depId = mod.getString("modId")) == null || !depId.equals("minecraft") && !depId.equals("neoforge") && !depId.equals("forge") || (depEnv = mod.getString("side")) == null) continue;
                        switch (depEnv.toLowerCase()) {
                            case "client": {
                                environment = LoaderManagerService.EnvironmentType.CLIENT;
                                break;
                            }
                            case "server": {
                                environment = LoaderManagerService.EnvironmentType.SERVER;
                            }
                        }
                        if (environment == LoaderManagerService.EnvironmentType.UNIVERSAL) continue;
                        return environment;
                    }
                    return environment;
                }
            }
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Error parsing TOML metadata: {}", (Object)e.getMessage());
        }
        return infoType.equals("version") || infoType.equals("modId") || infoType.equals("environment") ? null : Set.of();
    }

    private static Object getModInfoFromJson(BufferedReader reader, String infoType) {
        JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        switch (infoType) {
            case "version": {
                if (json.has("version")) {
                    return json.get("version").getAsString();
                }
                if (!json.has("quilt_loader") || !json.get("quilt_loader").getAsJsonObject().has("version")) break;
                return json.get("quilt_loader").getAsJsonObject().get("version").getAsString();
            }
            case "modId": {
                if (json.has("id")) {
                    return json.get("id").getAsString();
                }
                if (!json.has("quilt_loader") || !json.get("quilt_loader").getAsJsonObject().has("id")) break;
                return json.get("quilt_loader").getAsJsonObject().get("id").getAsString();
            }
            case "provides": {
                HashSet<String> providedIDs = new HashSet<String>();
                if (json.has("provides")) {
                    for (JsonElement provides : json.get("provides").getAsJsonArray()) {
                        providedIDs.add(provides.getAsString());
                    }
                } else if (json.has("quilt_loader") && json.get("quilt_loader").getAsJsonObject().has("provides")) {
                    JsonObject quiltLoader = json.get("quilt_loader").getAsJsonObject();
                    for (JsonElement provides : quiltLoader.get("provides").getAsJsonArray()) {
                        JsonObject providesObject = provides.getAsJsonObject();
                        String id = providesObject.get("id").getAsString();
                        providedIDs.add(id);
                    }
                }
                return providedIDs;
            }
            case "dependencies": {
                JsonObject depends;
                HashSet<String> dependencies = new HashSet<String>();
                if (json.has("depends")) {
                    JsonObject depends2 = json.get("depends").getAsJsonObject();
                    if (depends2 != null) {
                        dependencies.addAll(depends2.entrySet().stream().map(Map.Entry::getKey).toList());
                    }
                } else if (json.has("quilt_loader") && json.get("quilt_loader").getAsJsonObject().has("depends") && (depends = json.get("quilt_loader").getAsJsonObject().get("depends").getAsJsonObject()) != null) {
                    dependencies.addAll(depends.entrySet().stream().map(Map.Entry::getKey).toList());
                }
                return dependencies;
            }
            case "environment": {
                if (json.has("environment")) {
                    String environment = json.get("environment").getAsString();
                    if (environment == null) {
                        return LoaderManagerService.EnvironmentType.UNIVERSAL;
                    }
                    return switch (environment.toLowerCase()) {
                        case "client" -> LoaderManagerService.EnvironmentType.CLIENT;
                        case "server" -> LoaderManagerService.EnvironmentType.SERVER;
                        default -> LoaderManagerService.EnvironmentType.UNIVERSAL;
                    };
                }
                if (!json.has("quilt_loader") || !json.has("minecraft") || !json.get("minecraft").getAsJsonObject().has("environment")) break;
                String environment = json.get("minecraft").getAsJsonObject().get("environment").getAsString();
                if (environment == null) {
                    return LoaderManagerService.EnvironmentType.UNIVERSAL;
                }
                return switch (environment.toLowerCase()) {
                    case "client" -> LoaderManagerService.EnvironmentType.CLIENT;
                    case "server" -> LoaderManagerService.EnvironmentType.SERVER;
                    default -> LoaderManagerService.EnvironmentType.UNIVERSAL;
                };
            }
        }
        return infoType.equals("version") || infoType.equals("modId") || infoType.equals("environment") ? null : Set.of();
    }

    public static boolean isInValidFileName(String fileName) {
        for (char c : forbiddenChars.toCharArray()) {
            if (fileName.indexOf(c) == -1) continue;
            return true;
        }
        for (char c : fileName.toCharArray()) {
            if (c >= ' ' && c != '\u007f') continue;
            return true;
        }
        return fileName.trim().isEmpty();
    }

    public static String fixFileName(String fileName) {
        for (char c : fileName.toCharArray()) {
            if (c >= ' ' && c != '\u007f' && forbiddenChars.indexOf(c) == -1) continue;
            fileName = fileName.replace(c, '-');
        }
        return fileName.trim();
    }

    public record HashPathPair(String hash, Path path) {
    }

    public record Mod(String modID, String hash, Collection<String> providesIDs, String modVersion, Path modPath, LoaderManagerService.EnvironmentType environmentType, Collection<String> dependencies) {
    }
}

