/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import pl.skidam.automodpack_core.protocol.netty.message.EchoMessage;
import pl.skidam.automodpack_core.protocol.netty.message.FileRequestMessage;
import pl.skidam.automodpack_core.protocol.netty.message.FileResponseMessage;
import pl.skidam.automodpack_core.protocol.netty.message.ProtocolMessage;
import pl.skidam.automodpack_core.protocol.netty.message.RefreshRequestMessage;

public class ProtocolMessageEncoder
extends MessageToByteEncoder<ProtocolMessage> {
    protected void encode(ChannelHandlerContext ctx, ProtocolMessage msg, ByteBuf out) throws Exception {
        out.writeByte((int)msg.getVersion());
        out.writeByte((int)msg.getType());
        out.writeBytes(msg.getSecret());
        switch (msg.getType()) {
            case 0: {
                EchoMessage echoMsg = (EchoMessage)msg;
                out.writeInt(echoMsg.getDataLength());
                out.writeBytes(echoMsg.getData());
                break;
            }
            case 1: {
                FileRequestMessage fileRequestMessage = (FileRequestMessage)msg;
                out.writeInt(fileRequestMessage.getFileHashLength());
                out.writeBytes(fileRequestMessage.getFileHash());
                break;
            }
            case 2: {
                FileResponseMessage fileResponseMessage = (FileResponseMessage)msg;
                out.writeInt(fileResponseMessage.getDataLength());
                out.writeBytes(fileResponseMessage.getData());
                break;
            }
            case 3: {
                RefreshRequestMessage refreshRequestMessage = (RefreshRequestMessage)msg;
                out.writeInt(refreshRequestMessage.getFileHashesCount());
                out.writeInt(refreshRequestMessage.getFileHashesLength());
                for (byte[] fileHash : refreshRequestMessage.getFileHashesList()) {
                    out.writeBytes(fileHash);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown message type: " + msg.getType());
            }
        }
    }
}

