/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.pqc.jcajce.provider.bike;

import amp_libs.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import amp_libs.org.bouncycastle.pqc.crypto.bike.BIKEPublicKeyParameters;
import amp_libs.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import amp_libs.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import amp_libs.org.bouncycastle.pqc.jcajce.interfaces.BIKEKey;
import amp_libs.org.bouncycastle.pqc.jcajce.spec.BIKEParameterSpec;
import amp_libs.org.bouncycastle.util.Arrays;
import amp_libs.org.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;

public class BCBIKEPublicKey
implements PublicKey,
BIKEKey {
    private static final long serialVersionUID = 1L;
    private transient BIKEPublicKeyParameters params;

    public BCBIKEPublicKey(BIKEPublicKeyParameters bIKEPublicKeyParameters) {
        this.params = bIKEPublicKeyParameters;
    }

    public BCBIKEPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (BIKEPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCBIKEPublicKey) {
            BCBIKEPublicKey bCBIKEPublicKey = (BCBIKEPublicKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCBIKEPublicKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public BIKEParameterSpec getParameterSpec() {
        return BIKEParameterSpec.fromName(this.params.getParameters().getName());
    }

    BIKEPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

