/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_loader_core.platforms.CurseForgeAPI;
import pl.skidam.automodpack_loader_core.platforms.ModrinthAPI;

public class FetchManager {
    private final Map<String, Datas> fetchDatas = new HashMap<String, Datas>();
    public int fetchesDone = 0;
    private CompletableFuture<Void> completableFuture;

    public FetchManager(List<FetchData> fetchDatas) {
        for (FetchData fetchData : fetchDatas) {
            this.fetchDatas.put(fetchData.sha1, new Datas(fetchData, new FetchedData(new ArrayList<String>(), new ArrayList<String>())));
        }
    }

    public void cancel() {
        this.completableFuture.cancel(true);
    }

    public void fetch() {
        HashMap<String, String> cf = new HashMap<String, String>();
        ArrayList<String> mo = new ArrayList<String>();
        for (Map.Entry<String, Datas> entry : this.fetchDatas.entrySet()) {
            FetchData fetchData = entry.getValue().fetchData();
            if (fetchData.murmur != null && !fetchData.murmur.isBlank()) {
                cf.put(fetchData.sha1, fetchData.murmur);
            }
            mo.add(fetchData.sha1);
        }
        try {
            this.completableFuture = CompletableFuture.runAsync(() -> {
                this.fetchByMurmur(cf);
                this.fetchBySha1(mo);
            });
            this.completableFuture.join();
        }
        catch (CancellationException e) {
            GlobalVariables.LOGGER.warn("Fetch canceled");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchBySha1(List<String> sha1s) {
        List<ModrinthAPI> modrinthFileInfos = ModrinthAPI.getModsInfosFromListOfSHA1(sha1s);
        if (modrinthFileInfos == null) {
            return;
        }
        for (ModrinthAPI modrinthFileInfo : modrinthFileInfos) {
            String sha1 = modrinthFileInfo.SHA1Hash();
            Datas datas = this.fetchDatas.get(sha1);
            String mainPageUrl = ModrinthAPI.getMainPageUrl(modrinthFileInfo.modrinthID(), datas.fetchData.fileType);
            datas.fetchedData().urls().add(modrinthFileInfo.downloadUrl());
            datas.fetchedData().mainPageUrls().add(mainPageUrl);
            this.fetchDatas.put(sha1, datas);
            ++this.fetchesDone;
        }
    }

    private void fetchByMurmur(Map<String, String> hashes) {
        List<CurseForgeAPI> cfFileInfos = CurseForgeAPI.getModInfosFromFingerPrints(hashes);
        if (cfFileInfos == null) {
            return;
        }
        for (CurseForgeAPI cfFileInfo : cfFileInfos) {
            String sha1 = cfFileInfo.sha1Hash();
            Datas datas = this.fetchDatas.get(sha1);
            datas.fetchedData().urls().add(cfFileInfo.downloadUrl());
            this.fetchDatas.put(sha1, datas);
            ++this.fetchesDone;
        }
    }

    public Map<String, Datas> getFetchDatas() {
        return this.fetchDatas;
    }

    public record FetchData(String file, String sha1, String murmur, String fileSize, String fileType) {
    }

    public record Datas(FetchData fetchData, FetchedData fetchedData) {
    }

    public record FetchedData(List<String> urls, List<String> mainPageUrls) {
    }
}

