/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.Jsons;

public class ModpackContentTools {
    public static String getFileType(String file, Jsons.ModpackContentFields list) {
        for (Jsons.ModpackContentFields.ModpackContentItem item : list.list) {
            if (!item.file.contains(file)) continue;
            return item.type;
        }
        return "other";
    }

    public static Optional<Path> getModpackDir(String modpack) {
        if (modpack == null || modpack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(GlobalVariables.modpacksDir.resolve(modpack));
    }

    public static Optional<Path> getModpackContentFile(Path modpackDir) {
        if (!Files.exists(modpackDir, new LinkOption[0])) {
            return Optional.empty();
        }
        Path path = modpackDir.getParent().resolve(GlobalVariables.hostModpackContentFile.getFileName());
        if (!Files.exists(path, new LinkOption[0]) && !Files.exists(path = modpackDir.resolve(GlobalVariables.hostModpackContentFile.getFileName()), new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(path);
    }
}

