/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.cms;

import am_libs.org.bouncycastle.cms.CMSException;
import am_libs.org.bouncycastle.cms.CMSProcessable;
import am_libs.org.bouncycastle.cms.CMSReadable;
import am_libs.org.bouncycastle.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class CMSProcessableInputStream
implements CMSProcessable,
CMSReadable {
    private InputStream input;
    private boolean used = false;

    public CMSProcessableInputStream(InputStream inputStream) {
        this.input = inputStream;
    }

    @Override
    public InputStream getInputStream() {
        this.checkSingleUsage();
        return this.input;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException, CMSException {
        this.checkSingleUsage();
        Streams.pipeAll(this.input, outputStream);
        this.input.close();
    }

    @Override
    public Object getContent() {
        return this.getInputStream();
    }

    private synchronized void checkSingleUsage() {
        if (this.used) {
            throw new IllegalStateException("CMSProcessableInputStream can only be used once");
        }
        this.used = true;
    }
}

