/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Objects;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.utils.Json;

public class AddressHelpers {
    public static String getPublicIp() {
        String[] services;
        for (String service : services = new String[]{"https://ip.seeip.org/json", "https://api.ipify.org?format=json"}) {
            try {
                return Objects.requireNonNull(Json.fromUrl(service)).get("ip").getAsString();
            }
            catch (Exception exception) {
            }
        }
        GlobalVariables.LOGGER.error("AutoModpack couldn't get your public IP address, please configure it manually.");
        return null;
    }

    public static String getLocalIp() {
        return AddressHelpers.getNetworkIp(Inet4Address.class);
    }

    public static String getLocalIpv6() {
        return AddressHelpers.getNetworkIp(Inet6Address.class);
    }

    private static String getNetworkIp(Class<? extends InetAddress> ipClass) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (!ipClass.isInstance(addr) || addr.isLinkLocalAddress()) continue;
                    return addr.getHostAddress().split("%")[0];
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean areIpsEqual(String ip1, String ip2) {
        try {
            return InetAddress.getByName(ip1).equals(InetAddress.getByName(ip2));
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static String normalizeIp(String ip) {
        if (ip == null) {
            return null;
        }
        if ((ip = ip.trim()).startsWith("/")) {
            ip = ip.substring(1);
        }
        if (ip.contains(":")) {
            int portIndex = ip.lastIndexOf(":");
            ip = ip.substring(0, portIndex);
        }
        if (ip.startsWith("[") && ip.endsWith("]")) {
            ip = ip.substring(1, ip.length() - 1);
        }
        return ip;
    }

    public static InetSocketAddress format(String host, int port) {
        if (host.endsWith(".")) {
            host = host.substring(0, host.length() - 1);
        }
        return InetSocketAddress.createUnresolved(host, port);
    }

    public static InetSocketAddress parse(String address) {
        if (address == null) {
            return null;
        }
        InetSocketAddress socketAddress = null;
        try {
            int portIndex = address.lastIndexOf(58);
            if (portIndex != -1) {
                String host = address.substring(0, portIndex);
                String port = address.substring(portIndex + 1);
                if (port.matches("\\d+")) {
                    socketAddress = InetSocketAddress.createUnresolved(host, Integer.parseInt(port));
                }
            }
            if (socketAddress == null) {
                socketAddress = InetSocketAddress.createUnresolved(address, 0);
            }
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Error while parsing address", (Throwable)e);
        }
        return socketAddress;
    }

    public static boolean isLocal(String address) {
        if (address == null) {
            return true;
        }
        if ((address = AddressHelpers.normalizeIp(address)).startsWith("192.168.") || address.startsWith("127.") || address.startsWith("::1") || address.startsWith("0:0:0:0:")) {
            return true;
        }
        String localIp = AddressHelpers.getLocalIp();
        String localIpv6 = AddressHelpers.getLocalIpv6();
        return AddressHelpers.areIpsEqual(address, localIp) || AddressHelpers.areIpsEqual(address, localIpv6);
    }
}

