/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.modpack;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Stream;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.ConfigTools;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.loader.LoaderManagerService;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_core.utils.FileInspection;
import pl.skidam.automodpack_core.utils.FileTreeScanner;
import pl.skidam.automodpack_core.utils.ModpackContentTools;
import pl.skidam.automodpack_core.utils.ObservableMap;

public class ModpackContent {
    public final Set<Jsons.ModpackContentFields.ModpackContentItem> list = Collections.synchronizedSet(new HashSet());
    public final ObservableMap<String, Path> pathsMap = new ObservableMap();
    private final String MODPACK_NAME;
    private final FileTreeScanner SYNCED_FILES_CARDS;
    private final FileTreeScanner EDITABLE_CARDS;
    private final FileTreeScanner FORCE_COPY_FILES_TO_STANDARD_LOCATION;
    private final Path MODPACK_DIR;
    private final ThreadPoolExecutor CREATION_EXECUTOR;
    private final Map<String, String> sha1MurmurMapPreviousContent = new HashMap<String, String>();

    public ModpackContent(String modpackName, Path cwd, Path modpackDir, List<String> syncedFiles, List<String> allowEditsInFiles, List<String> forceCopyFilesToStandardLocation, ThreadPoolExecutor CREATION_EXECUTOR) {
        this.MODPACK_NAME = modpackName;
        this.MODPACK_DIR = modpackDir;
        HashSet<Path> directoriesToSearch = new HashSet<Path>(2);
        if (this.MODPACK_DIR != null) {
            directoriesToSearch.add(this.MODPACK_DIR);
        }
        if (cwd != null) {
            directoriesToSearch.add(cwd);
            this.SYNCED_FILES_CARDS = new FileTreeScanner(syncedFiles, Set.of(cwd));
        } else {
            this.SYNCED_FILES_CARDS = new FileTreeScanner(syncedFiles, Set.of());
        }
        this.EDITABLE_CARDS = new FileTreeScanner(allowEditsInFiles, directoriesToSearch);
        this.FORCE_COPY_FILES_TO_STANDARD_LOCATION = new FileTreeScanner(forceCopyFilesToStandardLocation, directoriesToSearch);
        this.CREATION_EXECUTOR = CREATION_EXECUTOR;
    }

    public String getModpackName() {
        return this.MODPACK_NAME;
    }

    public boolean create() {
        try {
            this.SYNCED_FILES_CARDS.scan();
            this.EDITABLE_CARDS.scan();
            this.FORCE_COPY_FILES_TO_STANDARD_LOCATION.scan();
            this.pathsMap.clear();
            this.sha1MurmurMapPreviousContent.clear();
            this.getPreviousContent().ifPresent(previousContent -> previousContent.list.forEach(item -> this.sha1MurmurMapPreviousContent.put(item.sha1, item.murmur)));
            List<CompletableFuture<Void>> creationFutures = Collections.synchronizedList(new ArrayList());
            if (this.MODPACK_DIR != null) {
                GlobalVariables.LOGGER.info("Syncing {}...", (Object)this.MODPACK_DIR.getFileName());
                try (Stream<Path> pathStream = Files.walk(this.MODPACK_DIR, new FileVisitOption[0]);){
                    creationFutures.addAll(this.generateAsync(pathStream.toList()));
                    creationFutures.forEach(CompletableFuture::join);
                    creationFutures.clear();
                }
            }
            creationFutures.addAll(this.generateAsync(this.SYNCED_FILES_CARDS.getMatchedPaths().values().stream().toList()));
            creationFutures.forEach(CompletableFuture::join);
            creationFutures.clear();
            if (this.list.isEmpty()) {
                GlobalVariables.LOGGER.warn("Modpack is empty!");
                return false;
            }
            HashSet dupeSet = new HashSet();
            this.list.removeIf(item -> !dupeSet.add(item.file));
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Error while generating modpack!", (Throwable)e);
            return false;
        }
        this.saveModpackContent();
        if (GlobalVariables.hostServer != null) {
            GlobalVariables.hostServer.addPaths(this.pathsMap);
        }
        return true;
    }

    public Optional<Jsons.ModpackContentFields> getPreviousContent() {
        Optional<Path> optionalModpackContentFile = ModpackContentTools.getModpackContentFile(this.MODPACK_DIR);
        return optionalModpackContentFile.map(ConfigTools::loadModpackContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadPreviousContent() {
        Optional<Jsons.ModpackContentFields> optionalModpackContent = this.getPreviousContent();
        if (optionalModpackContent.isEmpty()) {
            return false;
        }
        Jsons.ModpackContentFields modpackContent = optionalModpackContent.get();
        Set<Jsons.ModpackContentFields.ModpackContentItem> set = this.list;
        synchronized (set) {
            this.list.addAll(modpackContent.list);
            for (Jsons.ModpackContentFields.ModpackContentItem modpackContentItem : this.list) {
                Path file = CustomFileUtils.getPath(this.MODPACK_DIR, modpackContentItem.file);
                if (!Files.exists(file, new LinkOption[0])) {
                    file = CustomFileUtils.getPathFromCWD(modpackContentItem.file);
                }
                if (!Files.exists(file, new LinkOption[0])) {
                    GlobalVariables.LOGGER.warn("File {} does not exist!", (Object)file);
                    continue;
                }
                this.pathsMap.put(modpackContentItem.sha1, file);
            }
        }
        if (GlobalVariables.hostServer != null) {
            GlobalVariables.hostServer.addPaths(this.pathsMap);
        }
        this.saveModpackContent();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveModpackContent() {
        Set<Jsons.ModpackContentFields.ModpackContentItem> set = this.list;
        synchronized (set) {
            Jsons.ModpackContentFields modpackContent = new Jsons.ModpackContentFields(this.list);
            modpackContent.automodpackVersion = GlobalVariables.AM_VERSION;
            modpackContent.mcVersion = GlobalVariables.MC_VERSION;
            modpackContent.loaderVersion = GlobalVariables.LOADER_VERSION;
            modpackContent.loader = GlobalVariables.LOADER;
            modpackContent.modpackName = this.MODPACK_NAME;
            ConfigTools.saveModpackContent(GlobalVariables.hostModpackContentFile, modpackContent);
        }
    }

    private List<CompletableFuture<Void>> generateAsync(List<Path> files) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (int i = 0; i < files.size(); i += 6) {
            List<Path> subList = files.subList(i, Math.min(files.size(), i + 6));
            futures.add(CompletableFuture.runAsync(() -> subList.forEach(this::generate), this.CREATION_EXECUTOR));
        }
        return futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(Path file) {
        block5: {
            try {
                Jsons.ModpackContentFields.ModpackContentItem item = this.generateContent(file);
                if (item == null) break block5;
                GlobalVariables.LOGGER.info("generated content for {}", (Object)item.file);
                Set<Jsons.ModpackContentFields.ModpackContentItem> set = this.list;
                synchronized (set) {
                    this.list.add(item);
                }
                this.pathsMap.put(item.sha1, file);
            }
            catch (Exception e) {
                GlobalVariables.LOGGER.error("Error while generating content for: " + String.valueOf(file) + " generated from: " + String.valueOf(this.MODPACK_DIR), (Throwable)e);
            }
        }
    }

    public CompletableFuture<Void> replaceAsync(Path file) {
        return CompletableFuture.runAsync(() -> this.replace(file), this.CREATION_EXECUTOR);
    }

    public void replace(Path file) {
        this.remove(file);
        this.generate(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Path file) {
        String modpackFile = CustomFileUtils.formatPath(file, this.MODPACK_DIR);
        Set<Jsons.ModpackContentFields.ModpackContentItem> set = this.list;
        synchronized (set) {
            for (Jsons.ModpackContentFields.ModpackContentItem item : this.list) {
                if (!item.file.equals(modpackFile)) continue;
                this.pathsMap.remove(item.sha1);
                this.list.remove(item);
                GlobalVariables.LOGGER.info("Removed content for {}", (Object)modpackFile);
                break;
            }
        }
    }

    public static boolean isInnerFile(Path file) {
        boolean isInner;
        Path normalizedFilePath = file.toAbsolutePath().normalize();
        boolean bl = isInner = normalizedFilePath.startsWith(GlobalVariables.automodpackDir.toAbsolutePath().normalize()) && !normalizedFilePath.startsWith(GlobalVariables.hostModpackDir.toAbsolutePath().normalize());
        if (!isInner && normalizedFilePath.equals(GlobalVariables.hostModpackContentFile.toAbsolutePath().normalize())) {
            return true;
        }
        return isInner;
    }

    private Jsons.ModpackContentFields.ModpackContentItem generateContent(Path file) throws Exception {
        String type;
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return null;
        }
        if (GlobalVariables.serverConfig == null) {
            GlobalVariables.LOGGER.error("Server config is null!");
            return null;
        }
        if (ModpackContent.isInnerFile(file)) {
            return null;
        }
        String formattedFile = CustomFileUtils.formatPath(file, this.MODPACK_DIR);
        if (formattedFile.startsWith("/automodpack/")) {
            return null;
        }
        String size = String.valueOf(Files.size(file));
        if (GlobalVariables.serverConfig.autoExcludeUnnecessaryFiles) {
            if (size.equals("0")) {
                GlobalVariables.LOGGER.info("Skipping file {} because it is empty", (Object)formattedFile);
                return null;
            }
            if (file.getFileName().toString().startsWith(".")) {
                GlobalVariables.LOGGER.info("Skipping file {} is hidden", (Object)formattedFile);
                return null;
            }
            if (formattedFile.endsWith(".tmp")) {
                GlobalVariables.LOGGER.info("File {} is temporary! Skipping...", (Object)formattedFile);
                return null;
            }
            if (formattedFile.endsWith(".disabled")) {
                GlobalVariables.LOGGER.info("File {} is disabled! Skipping...", (Object)formattedFile);
                return null;
            }
            if (formattedFile.endsWith(".bak")) {
                GlobalVariables.LOGGER.info("File {} is backup file, unnecessary on client! Skipping...", (Object)formattedFile);
                return null;
            }
        }
        if (FileInspection.isMod(file)) {
            type = "mod";
            if (GlobalVariables.serverConfig.autoExcludeServerSideMods && Objects.equals((Object)FileInspection.getModEnvironment(file), (Object)LoaderManagerService.EnvironmentType.SERVER)) {
                GlobalVariables.LOGGER.info("File {} is server mod! Skipping...", (Object)formattedFile);
                return null;
            }
            String modId = FileInspection.getModID(file);
            if ("automodpack_bootstrap".equals(modId) || "automodpack-bootstrap".equals(modId) || "automodpack_mod".equals(modId) || "automodpack".equals(modId)) {
                return null;
            }
        } else {
            type = formattedFile.contains("/config/") ? "config" : (formattedFile.contains("/shaderpacks/") ? "shader" : (formattedFile.contains("/resourcepacks/") ? "resourcepack" : (formattedFile.endsWith("/options.txt") ? "mc_options" : "other")));
        }
        String sha1 = CustomFileUtils.getHash(file);
        String murmur = null;
        if ((type.equals("mod") || type.equals("shader") || type.equals("resourcepack")) && (murmur = this.sha1MurmurMapPreviousContent.get(sha1)) == null) {
            murmur = CustomFileUtils.getCurseforgeMurmurHash(file);
        }
        boolean isEditable = false;
        if (this.EDITABLE_CARDS.hasMatch(formattedFile)) {
            isEditable = true;
            GlobalVariables.LOGGER.info("File {} is editable!", (Object)formattedFile);
        }
        boolean forcedToCopy = false;
        if (this.FORCE_COPY_FILES_TO_STANDARD_LOCATION.hasMatch(formattedFile)) {
            forcedToCopy = true;
            GlobalVariables.LOGGER.info("File {} is forced to copy to standard location!", (Object)formattedFile);
        }
        return new Jsons.ModpackContentFields.ModpackContentItem(formattedFile, size, type, isEditable, forcedToCopy, sha1, murmur);
    }
}

