/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import java.lang.reflect.Method;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.security.CodeSource;
import pl.skidam.automodpack_core.GlobalVariables;

public class JarUtils {
    public static Path getJarPath(Class<?> clazz) {
        try {
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource == null || codeSource.getLocation() == null) {
                throw new IllegalStateException("CodeSource is null for " + clazz.getSimpleName());
            }
            Path path = Path.of(codeSource.getLocation().toURI());
            return JarUtils.resolvePhysicalPath(path);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to determine JAR path for " + clazz.getSimpleName(), e);
        }
    }

    private static Path resolvePhysicalPath(Path path) {
        try {
            FileSystem fs = path.getFileSystem();
            Method method = fs.getClass().getMethod("getPrimaryPath", new Class[0]);
            Object result = method.invoke((Object)fs, new Object[0]);
            if (result instanceof Path) {
                return (Path)result;
            }
        }
        catch (NoSuchMethodException fs) {
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Failed to resolve physical path for {}", (Object)path, (Object)e);
        }
        return path;
    }
}

