/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.loader.LoaderManagerService;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_core.utils.LockFreeInputStream;
import pl.skidam.automodpack_core.utils.SemanticVersion;
import pl.skidam.automodpack_loader_core.ReLauncher;
import pl.skidam.automodpack_loader_core.platforms.ModrinthAPI;
import pl.skidam.automodpack_loader_core.screen.ScreenManager;
import pl.skidam.automodpack_loader_core.utils.DownloadManager;
import pl.skidam.automodpack_loader_core.utils.UpdateType;

public class SelfUpdater {
    public static final String AUTOMODPACK_ID = "k68glP2e";
    private static final SemanticVersion MINIMUM_SAFE_VERSION = new SemanticVersion(4, 0, 0, "release", Integer.MAX_VALUE);

    public static boolean update() {
        return SelfUpdater.update(null);
    }

    public static boolean update(Jsons.ModpackContentFields serverModpackContent) {
        SemanticVersion currentVersion;
        boolean gettingServerVersion;
        if (GlobalVariables.LOADER_MANAGER.isDevelopmentEnvironment()) {
            return false;
        }
        if (GlobalVariables.LOADER_MANAGER.getEnvironmentType() == LoaderManagerService.EnvironmentType.SERVER && !GlobalVariables.serverConfig.selfUpdater) {
            GlobalVariables.LOGGER.info("AutoModpack self-updater is disabled in server config.");
            return false;
        }
        boolean bl = gettingServerVersion = serverModpackContent != null && serverModpackContent.automodpackVersion != null && !serverModpackContent.automodpackVersion.isBlank();
        if (!gettingServerVersion && GlobalVariables.LOADER_MANAGER.getEnvironmentType() == LoaderManagerService.EnvironmentType.CLIENT && !GlobalVariables.clientConfig.selfUpdater) {
            GlobalVariables.LOGGER.info("AutoModpack self-updater is disabled in client config.");
            return false;
        }
        try {
            currentVersion = SemanticVersion.parse(GlobalVariables.AM_VERSION);
        }
        catch (IllegalArgumentException e) {
            GlobalVariables.LOGGER.error("Current installed AutoModpack version is corrupt/invalid: " + GlobalVariables.AM_VERSION);
            return false;
        }
        List<Object> modrinthAPIList = new ArrayList();
        if (gettingServerVersion) {
            if (serverModpackContent.automodpackVersion.equals(GlobalVariables.AM_VERSION)) {
                GlobalVariables.LOGGER.info("AutoModpack is up-to-date with server version: {}", (Object)serverModpackContent.automodpackVersion);
                return false;
            }
            if (!GlobalVariables.clientConfig.syncAutoModpackVersion) {
                GlobalVariables.LOGGER.warn("Version syncing disabled. Cannot sync to server version: {}", (Object)serverModpackContent.automodpackVersion);
                return false;
            }
            GlobalVariables.LOGGER.info("Syncing AutoModpack to server version: {}", (Object)serverModpackContent.automodpackVersion);
            modrinthAPIList.add(ModrinthAPI.getModSpecificVersion(AUTOMODPACK_ID, serverModpackContent.automodpackVersion, serverModpackContent.mcVersion));
        } else {
            GlobalVariables.LOGGER.info("Checking if AutoModpack is up-to-date...");
            modrinthAPIList = ModrinthAPI.getModInfosFromID(AUTOMODPACK_ID);
        }
        if (modrinthAPIList == null || modrinthAPIList.isEmpty()) {
            GlobalVariables.LOGGER.warn("Couldn't get version info from Modrinth API.");
            return false;
        }
        for (ModrinthAPI modrinthAPI : modrinthAPIList) {
            SemanticVersion remoteVersion;
            if (modrinthAPI == null || modrinthAPI.fileVersion() == null) continue;
            String rawRemoteVersion = modrinthAPI.fileVersion();
            try {
                remoteVersion = SemanticVersion.parse(rawRemoteVersion);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (modrinthAPI.SHA1Hash().equals(CustomFileUtils.getHash(GlobalVariables.THIS_MOD_JAR))) {
                GlobalVariables.LOGGER.info("Already on the target version (Hash match): {}", (Object)GlobalVariables.AM_VERSION);
                return false;
            }
            int comparison = remoteVersion.compareTo(currentVersion);
            if (!gettingServerVersion && comparison <= 0) {
                if (comparison == 0) {
                    GlobalVariables.LOGGER.info("No updates found. You are on the latest version: {}", (Object)rawRemoteVersion);
                } else {
                    GlobalVariables.LOGGER.info("Development check: Installed version {} is newer/different than release {}.", (Object)GlobalVariables.AM_VERSION, (Object)rawRemoteVersion);
                }
                return false;
            }
            if (!gettingServerVersion && currentVersion.isStable() && !remoteVersion.isStable()) {
                GlobalVariables.LOGGER.info("Skipping update: You are on Stable ({}) and latest is Pre-release ({}).", (Object)GlobalVariables.AM_VERSION, (Object)rawRemoteVersion);
                continue;
            }
            if (!SelfUpdater.validUpdate(remoteVersion)) {
                if (!gettingServerVersion) continue;
                return false;
            }
            GlobalVariables.LOGGER.info("Update found! Updating from {} to {}", (Object)GlobalVariables.AM_VERSION, (Object)rawRemoteVersion);
            SelfUpdater.installModVersion(modrinthAPI);
            return true;
        }
        if (!gettingServerVersion) {
            GlobalVariables.LOGGER.info("No suitable updates found.");
        }
        return false;
    }

    public static boolean validUpdate(SemanticVersion remoteVersion) {
        if (remoteVersion.compareTo(MINIMUM_SAFE_VERSION) < 0) {
            GlobalVariables.LOGGER.error("Downgrading AutoModpack to version {} is strongly discouraged/disabled due to security concerns (Target is older than 4.0.0 Stable).", (Object)remoteVersion);
            return false;
        }
        return true;
    }

    public static void installModVersion(ModrinthAPI automodpack) {
        Path automodpackUpdateJar = GlobalVariables.automodpackDir.resolve(automodpack.fileName());
        try {
            DownloadManager downloadManager = new DownloadManager();
            new ScreenManager().download(downloadManager, "AutoModpack " + automodpack.fileVersion());
            downloadManager.download(automodpackUpdateJar, automodpack.SHA1Hash(), List.of(automodpack.downloadUrl()), () -> GlobalVariables.LOGGER.info("Downloaded update for AutoModpack."), () -> GlobalVariables.LOGGER.error("Failed to download update for AutoModpack."));
            downloadManager.joinAll();
            downloadManager.cancelAllAndShutdown();
            SelfUpdater.addOverridesToJar(automodpackUpdateJar);
            Path newAutomodpackJar = GlobalVariables.THIS_MOD_JAR.getParent().resolve(automodpackUpdateJar.getFileName());
            UpdateType updateType = UpdateType.AUTOMODPACK;
            ReLauncher relauncher = new ReLauncher(updateType);
            Runnable callback = () -> {
                CustomFileUtils.executeOrder66(GlobalVariables.THIS_MOD_JAR);
                GlobalVariables.LOGGER.info("Successfully updated AutoModpack! Restarting...");
            };
            CustomFileUtils.copyFile(automodpackUpdateJar, newAutomodpackJar);
            CustomFileUtils.executeOrder66(automodpackUpdateJar);
            relauncher.restart(true, callback);
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Failed to update! " + String.valueOf(e));
        }
    }

    public static Optional<InputStream> getJarEntryInputStream(Path jarFilePath, String entryName) throws IOException {
        try (LockFreeInputStream fileStream = new LockFreeInputStream(jarFilePath);
             ZipInputStream zipStream = new ZipInputStream(fileStream);){
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                if (!entry.getName().equals(entryName)) continue;
                Optional<InputStream> optional = Optional.of(zipStream);
                return optional;
            }
        }
        return Optional.empty();
    }

    public static void addOverridesToJar(Path jarFilePath) throws IOException {
        if (GlobalVariables.clientConfigOverride == null || GlobalVariables.clientConfigOverride.isBlank()) {
            return;
        }
        if (!Files.isRegularFile(jarFilePath, new LinkOption[0]) || !Files.isRegularFile(GlobalVariables.THIS_MOD_JAR, new LinkOption[0])) {
            GlobalVariables.LOGGER.error("Jar file of updated AutoModpack not found!");
            return;
        }
        Path tempJarPath = Files.createTempFile("tempAutoModpackJar", ".jar", new FileAttribute[0]);
        try (JarFile jarFile = new JarFile(jarFilePath.toFile());
             JarOutputStream tempJarOutputStream = new JarOutputStream(Files.newOutputStream(tempJarPath, new OpenOption[0]));){
            jarFile.stream().forEach(entry -> {
                try {
                    JarEntry newEntry = new JarEntry(entry.getName());
                    tempJarOutputStream.putNextEntry(newEntry);
                    try (InputStream entryInputStream = jarFile.getInputStream((ZipEntry)entry);){
                        entryInputStream.transferTo(tempJarOutputStream);
                    }
                    tempJarOutputStream.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            Optional<InputStream> txtInputStreamOpt = SelfUpdater.getJarEntryInputStream(GlobalVariables.THIS_MOD_JAR, "overrides-automodpack-client.json");
            if (txtInputStreamOpt.isPresent()) {
                JarEntry newTxtEntry = new JarEntry("overrides-automodpack-client.json");
                tempJarOutputStream.putNextEntry(newTxtEntry);
                txtInputStreamOpt.get().transferTo(tempJarOutputStream);
                tempJarOutputStream.closeEntry();
            }
        }
        Files.move(tempJarPath, jarFilePath, StandardCopyOption.REPLACE_EXISTING);
        GlobalVariables.LOGGER.info("Added config overrides to the updated AutoModpack JAR");
    }
}

