/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.cms;

import am_libs.org.bouncycastle.asn1.DEROctetString;
import am_libs.org.bouncycastle.asn1.cms.KEKIdentifier;
import am_libs.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import am_libs.org.bouncycastle.asn1.cms.RecipientInfo;
import am_libs.org.bouncycastle.cms.CMSException;
import am_libs.org.bouncycastle.cms.RecipientInfoGenerator;
import am_libs.org.bouncycastle.operator.GenericKey;
import am_libs.org.bouncycastle.operator.OperatorException;
import am_libs.org.bouncycastle.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kEKIdentifier, SymmetricKeyWrapper symmetricKeyWrapper) {
        this.kekIdentifier = kEKIdentifier;
        this.wrapper = symmetricKeyWrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        try {
            DEROctetString dEROctetString = new DEROctetString(this.wrapper.generateWrappedKey(genericKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), dEROctetString));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
    }
}

