/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.cms;

import am_libs.org.bouncycastle.asn1.ASN1OctetStringParser;
import am_libs.org.bouncycastle.asn1.ASN1SequenceParser;
import am_libs.org.bouncycastle.asn1.cms.CompressedDataParser;
import am_libs.org.bouncycastle.asn1.cms.ContentInfoParser;
import am_libs.org.bouncycastle.cms.CMSContentInfoParser;
import am_libs.org.bouncycastle.cms.CMSException;
import am_libs.org.bouncycastle.cms.CMSTypedStream;
import am_libs.org.bouncycastle.operator.InputExpander;
import am_libs.org.bouncycastle.operator.InputExpanderProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CMSCompressedDataParser
extends CMSContentInfoParser {
    public CMSCompressedDataParser(byte[] byArray) throws CMSException {
        this(new ByteArrayInputStream(byArray));
    }

    public CMSCompressedDataParser(InputStream inputStream) throws CMSException {
        super(inputStream);
    }

    public CMSTypedStream getContent(InputExpanderProvider inputExpanderProvider) throws CMSException {
        try {
            CompressedDataParser compressedDataParser = new CompressedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
            ContentInfoParser contentInfoParser = compressedDataParser.getEncapContentInfo();
            InputExpander inputExpander = inputExpanderProvider.get(compressedDataParser.getCompressionAlgorithmIdentifier());
            ASN1OctetStringParser aSN1OctetStringParser = (ASN1OctetStringParser)contentInfoParser.getContent(4);
            return new CMSTypedStream(contentInfoParser.getContentType(), inputExpander.getInputStream(aSN1OctetStringParser.getOctetStream()));
        }
        catch (IOException iOException) {
            throw new CMSException("IOException reading compressed content.", iOException);
        }
    }
}

