/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.apache.hc.client5.http.impl.classic;

import amp_libs.org.apache.hc.client5.http.CircularRedirectException;
import amp_libs.org.apache.hc.client5.http.HttpRoute;
import amp_libs.org.apache.hc.client5.http.RedirectException;
import amp_libs.org.apache.hc.client5.http.auth.AuthExchange;
import amp_libs.org.apache.hc.client5.http.classic.ExecChain;
import amp_libs.org.apache.hc.client5.http.classic.ExecChainHandler;
import amp_libs.org.apache.hc.client5.http.config.RequestConfig;
import amp_libs.org.apache.hc.client5.http.impl.classic.RequestEntityProxy;
import amp_libs.org.apache.hc.client5.http.protocol.HttpClientContext;
import amp_libs.org.apache.hc.client5.http.protocol.RedirectLocations;
import amp_libs.org.apache.hc.client5.http.protocol.RedirectStrategy;
import amp_libs.org.apache.hc.client5.http.routing.HttpRoutePlanner;
import amp_libs.org.apache.hc.client5.http.utils.URIUtils;
import amp_libs.org.apache.hc.core5.annotation.Contract;
import amp_libs.org.apache.hc.core5.annotation.Internal;
import amp_libs.org.apache.hc.core5.annotation.ThreadingBehavior;
import amp_libs.org.apache.hc.core5.http.ClassicHttpRequest;
import amp_libs.org.apache.hc.core5.http.ClassicHttpResponse;
import amp_libs.org.apache.hc.core5.http.HttpEntity;
import amp_libs.org.apache.hc.core5.http.HttpException;
import amp_libs.org.apache.hc.core5.http.HttpHost;
import amp_libs.org.apache.hc.core5.http.Method;
import amp_libs.org.apache.hc.core5.http.ProtocolException;
import amp_libs.org.apache.hc.core5.http.io.entity.EntityUtils;
import amp_libs.org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import amp_libs.org.apache.hc.core5.util.Args;
import amp_libs.org.slf4j.Logger;
import amp_libs.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class RedirectExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RedirectExec.class);
    private final RedirectStrategy redirectStrategy;
    private final HttpRoutePlanner routePlanner;

    public RedirectExec(HttpRoutePlanner routePlanner, RedirectStrategy redirectStrategy) {
        Args.notNull(routePlanner, "HTTP route planner");
        Args.notNull(redirectStrategy, "HTTP redirect strategy");
        this.routePlanner = routePlanner;
        this.redirectStrategy = redirectStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull(request, "HTTP request");
        Args.notNull(scope, "Scope");
        HttpClientContext context = scope.clientContext;
        context.setRedirectLocations(null);
        RequestConfig config = context.getRequestConfigOrDefault();
        int maxRedirects = config.getMaxRedirects() > 0 ? config.getMaxRedirects() : 50;
        ClassicHttpRequest currentRequest = request;
        ExecChain.Scope currentScope = scope;
        int redirectCount = 0;
        while (true) {
            String exchangeId = currentScope.exchangeId;
            ClassicHttpResponse response = chain.proceed(currentRequest, currentScope);
            try {
                HttpRoute newRoute;
                ClassicHttpRequest redirect;
                URI redirectUri;
                block28: {
                    HttpRoute currentRoute;
                    block27: {
                        ClassicRequestBuilder redirectBuilder;
                        HttpHost newTarget;
                        if (!config.isRedirectsEnabled()) return response;
                        if (!this.redirectStrategy.isRedirected(request, response, context)) return response;
                        HttpEntity requestEntity = request.getEntity();
                        if (requestEntity != null && !requestEntity.isRepeatable()) {
                            if (!LOG.isDebugEnabled()) return response;
                            LOG.debug("{} cannot redirect non-repeatable request", (Object)exchangeId);
                            return response;
                        }
                        if (redirectCount >= maxRedirects) {
                            throw new RedirectException("Maximum redirects (" + maxRedirects + ") exceeded");
                        }
                        ++redirectCount;
                        redirectUri = this.redirectStrategy.getLocationURI(currentRequest, response, context);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} redirect requested to location '{}'", (Object)exchangeId, (Object)redirectUri);
                        }
                        if ((newTarget = URIUtils.extractHost(redirectUri)) == null) {
                            throw new ProtocolException("Redirect URI does not specify a valid host name: " + redirectUri);
                        }
                        RedirectLocations redirectLocations = context.getRedirectLocations();
                        if (!config.isCircularRedirectsAllowed() && redirectLocations.contains(redirectUri)) {
                            throw new CircularRedirectException("Circular redirect to '" + redirectUri + "'");
                        }
                        int statusCode = response.getCode();
                        switch (statusCode) {
                            case 301: 
                            case 302: {
                                if (Method.POST.isSame(request.getMethod())) {
                                    redirectBuilder = ClassicRequestBuilder.get();
                                    break;
                                }
                                redirectBuilder = ClassicRequestBuilder.copy(currentScope.originalRequest);
                                break;
                            }
                            case 303: {
                                if (!Method.GET.isSame(request.getMethod()) && !Method.HEAD.isSame(request.getMethod())) {
                                    redirectBuilder = ClassicRequestBuilder.get();
                                    break;
                                }
                                redirectBuilder = ClassicRequestBuilder.copy(currentScope.originalRequest);
                                break;
                            }
                            default: {
                                redirectBuilder = ClassicRequestBuilder.copy(currentScope.originalRequest);
                            }
                        }
                        redirectBuilder.setUri(redirectUri);
                        redirect = redirectBuilder.build();
                        currentRoute = currentScope.route;
                        HttpHost currentHost = currentRoute.getTargetHost();
                        if (!this.redirectStrategy.isRedirectAllowed(currentHost, newTarget, redirect, context)) {
                            if (!LOG.isDebugEnabled()) return response;
                            LOG.debug("{} cannot redirect due to safety restrictions", (Object)exchangeId);
                            return response;
                        }
                        redirectLocations.add(redirectUri);
                        if (Objects.equals(currentHost, newTarget)) break block27;
                        newRoute = this.routePlanner.determineRoute(newTarget, context);
                        if (!Objects.equals(currentRoute, newRoute)) {
                            AuthExchange proxyAuthExchange;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} new route required", (Object)exchangeId);
                            }
                            AuthExchange targetAuthExchange = context.getAuthExchange(currentHost);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} resetting target auth state", (Object)exchangeId);
                            }
                            targetAuthExchange.reset();
                            HttpHost proxyHost = currentRoute.getProxyHost();
                            if (proxyHost != null && (proxyAuthExchange = context.getAuthExchange(proxyHost)).isConnectionBased()) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("{} resetting proxy auth state", (Object)exchangeId);
                                }
                                proxyAuthExchange.reset();
                            }
                        }
                        break block28;
                    }
                    newRoute = currentRoute;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} redirecting to '{}' via {}", exchangeId, redirectUri, newRoute);
                }
                currentScope = new ExecChain.Scope(scope.exchangeId, newRoute, ClassicRequestBuilder.copy(redirect).build(), scope.execRuntime, scope.clientContext);
                currentRequest = redirect;
                RequestEntityProxy.enhance(currentRequest);
                EntityUtils.consume(response.getEntity());
                response.close();
            }
            catch (IOException | RuntimeException ex) {
                response.close();
                throw ex;
            }
            catch (HttpException ex) {
                try {
                    EntityUtils.consume(response.getEntity());
                    throw ex;
                }
                catch (IOException ioex) {
                    if (!LOG.isDebugEnabled()) throw ex;
                    LOG.debug("{} I/O error while releasing connection", (Object)exchangeId, (Object)ioex);
                    throw ex;
                }
                finally {
                    response.close();
                }
            }
        }
    }
}

