/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.cms;

import amp_libs.org.bouncycastle.asn1.cms.KEKIdentifier;
import amp_libs.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import amp_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import amp_libs.org.bouncycastle.cms.CMSException;
import amp_libs.org.bouncycastle.cms.CMSSecureReadable;
import amp_libs.org.bouncycastle.cms.KEKRecipient;
import amp_libs.org.bouncycastle.cms.KEKRecipientId;
import amp_libs.org.bouncycastle.cms.Recipient;
import amp_libs.org.bouncycastle.cms.RecipientInformation;
import amp_libs.org.bouncycastle.cms.RecipientOperator;
import java.io.IOException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

