/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.nio.charset.StandardCharsets;
import java.util.List;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.protocol.netty.NettyServer;
import pl.skidam.automodpack_core.protocol.netty.TrafficShaper;
import pl.skidam.automodpack_core.protocol.netty.handler.CompressionDecoder;
import pl.skidam.automodpack_core.protocol.netty.handler.CompressionEncoder;
import pl.skidam.automodpack_core.protocol.netty.handler.ConfigurationHandler;
import pl.skidam.automodpack_core.protocol.netty.handler.ErrorPrinter;
import pl.skidam.automodpack_core.protocol.netty.handler.ProtocolMessageDecoder;
import pl.skidam.automodpack_core.protocol.netty.handler.ServerMessageHandler;

public class ProtocolServerHandler
extends ByteToMessageDecoder {
    private static final byte[] MAGIC_AMMH_ARRAY = new byte[]{65, 77, 77, 72};
    private final SslContext sslCtx;

    public ProtocolServerHandler(SslContext sslCtx) {
        this.sslCtx = sslCtx;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        boolean isSharedPort = GlobalVariables.serverConfig.bindPort == -1 && GlobalVariables.hostServer.isRunning();
        int readerIndex = in.readerIndex();
        int readableBytes = in.readableBytes();
        for (int i = 0; i < MAGIC_AMMH_ARRAY.length; ++i) {
            if (readableBytes <= i) {
                return;
            }
            if (in.getByte(readerIndex + i) == MAGIC_AMMH_ARRAY[i]) continue;
            if (isSharedPort) {
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.fireChannelRead((Object)in.retain());
                in.skipBytes(in.readableBytes());
            } else {
                this.fallbackToStandardProtocol(ctx, in);
            }
            return;
        }
        this.handleMagicPacket(ctx, in);
    }

    private void handleMagicPacket(ChannelHandlerContext ctx, ByteBuf in) {
        if (in.readableBytes() < 6) {
            return;
        }
        in.markReaderIndex();
        in.skipBytes(4);
        short hostnameLength = in.readShort();
        in.resetReaderIndex();
        if (in.readableBytes() < 6 + hostnameLength) {
            return;
        }
        in.skipBytes(6);
        byte[] hostnameBytes = new byte[hostnameLength];
        in.readBytes(hostnameBytes);
        String hostname = new String(hostnameBytes, StandardCharsets.UTF_8);
        GlobalVariables.LOGGER.debug("Received AMMH handshake. Hostname: {}", (Object)hostname);
        this.finalizeHandshake(ctx);
    }

    private void fallbackToStandardProtocol(ChannelHandlerContext ctx, ByteBuf in) {
        this.setupPipeline(ctx);
        ctx.pipeline().remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)in.retain());
        in.skipBytes(in.readableBytes());
    }

    private void finalizeHandshake(ChannelHandlerContext ctx) {
        this.sendAck(ctx);
        ctx.pipeline().toMap().forEach((k, v) -> ctx.pipeline().remove(v));
        this.setupPipeline(ctx);
    }

    private void sendAck(ChannelHandlerContext ctx) {
        ByteBuf response = ctx.alloc().buffer(4);
        response.writeInt(1095585611);
        ctx.writeAndFlush((Object)response);
    }

    private void setupPipeline(ChannelHandlerContext ctx) {
        ctx.pipeline().addLast("error-printer-first", (ChannelHandler)new ErrorPrinter());
        ctx.pipeline().addLast("traffic-shaper", (ChannelHandler)TrafficShaper.trafficShaper.getTrafficShapingHandler());
        if (this.sslCtx != null) {
            ctx.pipeline().addLast("tls", (ChannelHandler)this.sslCtx.newHandler(ctx.alloc()));
            GlobalVariables.LOGGER.debug("Pipeline: TLS Enabled");
        } else {
            GlobalVariables.LOGGER.debug("Pipeline: TLS Disabled");
        }
        ctx.channel().attr(NettyServer.PROTOCOL_VERSION).set((Object)1);
        ctx.channel().attr(NettyServer.COMPRESSION_TYPE).set((Object)1);
        ctx.channel().attr(NettyServer.CHUNK_SIZE).set((Object)262144);
        ctx.pipeline().addLast("configuration-handler", (ChannelHandler)new ConfigurationHandler()).addLast("compression-encoder", (ChannelHandler)new CompressionEncoder()).addLast("compression-decoder", (ChannelHandler)new CompressionDecoder()).addLast("chunked-write", (ChannelHandler)new ChunkedWriteHandler()).addLast("protocol-msg-decoder", (ChannelHandler)new ProtocolMessageDecoder()).addLast("msg-handler", (ChannelHandler)new ServerMessageHandler()).addLast("error-printer-last", (ChannelHandler)new ErrorPrinter());
    }
}

