/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.utils.FileSystemCapabilities;

public class FileTreeScanner {
    private volatile Map<String, Path> wildcardMatches = Map.of();
    private final Object lock = new Object();
    private final List<PathMatcher> whiteListMatchers = new ArrayList<PathMatcher>();
    private final List<PathMatcher> blackListMatchers = new ArrayList<PathMatcher>();
    private final List<PruningRule> pruningRules = new ArrayList<PruningRule>();
    private final Set<Path> startDirectories;
    private final FileSystem fs;
    private final boolean isCaseInsensitive;

    public FileTreeScanner(List<String> rules, Set<Path> startDirectories) {
        this(rules, startDirectories, FileSystems.getDefault());
    }

    public FileTreeScanner(List<String> rules, Set<Path> startDirectories, FileSystem fs) {
        this.startDirectories = startDirectories != null ? startDirectories : Set.of();
        this.isCaseInsensitive = FileSystemCapabilities.isCaseInsensitive(fs);
        this.fs = fs;
        this.parseRules(rules);
    }

    public Map<String, Path> getMatchedPaths() {
        return this.wildcardMatches;
    }

    public boolean hasMatch(String pathStr) {
        return pathStr != null && this.wildcardMatches.containsKey(pathStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() {
        Object object = this.lock;
        synchronized (object) {
            if (this.whiteListMatchers.isEmpty()) {
                return;
            }
            HashMap<String, Path> localMatches = new HashMap<String, Path>(512);
            EnumSet<FileVisitOption> options = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            for (Path startDir : this.startDirectories) {
                if (startDir == null || !Files.exists(startDir, new LinkOption[0])) continue;
                Path absStartDir = startDir.toAbsolutePath().normalize();
                try {
                    Files.walkFileTree(startDir, options, Integer.MAX_VALUE, new Visitor(startDir, absStartDir, localMatches));
                }
                catch (IOException e) {
                    GlobalVariables.LOGGER.error("Error walking directory: {}", (Object)startDir, (Object)e);
                }
            }
            this.wildcardMatches = Map.copyOf(localMatches);
        }
    }

    private String formatOutputKey(Path relativePath) {
        String pathStr = relativePath.toString().replace(this.fs.getSeparator(), "/");
        return pathStr.startsWith("/") ? pathStr : "/" + pathStr;
    }

    private void parseRules(List<String> rawRules) {
        if (rawRules == null) {
            return;
        }
        for (String rule : rawRules) {
            String clean;
            if (rule == null || rule.isBlank()) continue;
            boolean isBlacklist = rule.startsWith("!");
            String string = clean = isBlacklist ? rule.substring(1) : rule;
            if (clean.startsWith("/")) {
                clean = clean.substring(1);
            }
            while (clean.contains("**/**")) {
                clean = clean.replace("**/**", "**");
            }
            try {
                String prefix;
                PathMatcher matcher = this.fs.getPathMatcher("glob:" + clean);
                if (isBlacklist) {
                    this.blackListMatchers.add(matcher);
                    continue;
                }
                this.whiteListMatchers.add(matcher);
                if (clean.contains("/**/")) {
                    String collapsed = clean.replace("/**/", "/");
                    this.whiteListMatchers.add(this.fs.getPathMatcher("glob:" + collapsed));
                }
                this.pruningRules.add(PruningRule.compile(clean, this.fs, this.isCaseInsensitive));
                if (!clean.contains("/**/") || (prefix = clean.substring(0, clean.indexOf("/**/"))).isEmpty()) continue;
                this.pruningRules.add(PruningRule.compile(prefix, this.fs, this.isCaseInsensitive));
            }
            catch (Exception e) {
                GlobalVariables.LOGGER.error("Invalid glob: {}", (Object)rule, (Object)e);
            }
        }
    }

    private class Visitor
    extends SimpleFileVisitor<Path> {
        private final Path startDir;
        private final Path absStartDir;
        private final int startDirCount;
        private final Map<String, Path> targetMap;

        Visitor(Path startDir, Path absStartDir, Map<String, Path> targetMap) {
            this.startDir = startDir;
            this.absStartDir = absStartDir;
            this.startDirCount = startDir.getNameCount();
            this.targetMap = targetMap;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (dir.equals(this.startDir)) {
                return FileVisitResult.CONTINUE;
            }
            try {
                Path absDir;
                if (attrs.isSymbolicLink() && !(absDir = dir.toAbsolutePath().normalize()).startsWith(this.absStartDir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            catch (Exception e) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            Path fileNamePath = dir.getFileName();
            if (fileNamePath != null) {
                int depth = dir.getNameCount() - this.startDirCount;
                if (!this.couldMatchStructure(fileNamePath.toString(), depth)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            Path relative;
            try {
                relative = this.startDir.relativize(file);
            }
            catch (IllegalArgumentException e) {
                return FileVisitResult.CONTINUE;
            }
            int whiteSize = FileTreeScanner.this.whiteListMatchers.size();
            for (int i = 0; i < whiteSize; ++i) {
                if (!FileTreeScanner.this.whiteListMatchers.get(i).matches(relative)) continue;
                int blackSize = FileTreeScanner.this.blackListMatchers.size();
                for (int j = 0; j < blackSize; ++j) {
                    if (!FileTreeScanner.this.blackListMatchers.get(j).matches(relative)) continue;
                    return FileVisitResult.CONTINUE;
                }
                this.targetMap.put(FileTreeScanner.this.formatOutputKey(relative), file);
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            if (exc instanceof FileSystemLoopException) {
                GlobalVariables.LOGGER.warn("Cycle: {}", (Object)file);
            } else if (exc instanceof AccessDeniedException) {
                GlobalVariables.LOGGER.info("Access denied: {}", (Object)file);
            } else {
                GlobalVariables.LOGGER.error("Visit failed: {} ({})", (Object)file, (Object)exc);
            }
            return FileVisitResult.CONTINUE;
        }

        private boolean couldMatchStructure(String dirName, int depth) {
            if (FileTreeScanner.this.pruningRules.isEmpty()) {
                return false;
            }
            int size = FileTreeScanner.this.pruningRules.size();
            for (int i = 0; i < size; ++i) {
                if (!FileTreeScanner.this.pruningRules.get(i).allows(dirName, depth)) continue;
                return true;
            }
            return false;
        }
    }

    private record PruningRule(GlobComponent[] components, int firstDoubleWildcardIdx) {
        static PruningRule compile(String pattern, FileSystem fs, boolean isCaseInsensitive) {
            String[] parts = pattern.split("/");
            ArrayList<GlobComponent> comps = new ArrayList<GlobComponent>(parts.length);
            int firstDouble = -1;
            for (String part : parts) {
                if (part.isEmpty()) continue;
                GlobComponent c = new GlobComponent(part, fs, isCaseInsensitive);
                comps.add(c);
                if (firstDouble != -1 || !c.isDoubleWildcard) continue;
                firstDouble = comps.size() - 1;
            }
            return new PruningRule(comps.toArray(new GlobComponent[0]), firstDouble);
        }

        boolean allows(String currentName, int depth) {
            if (this.firstDoubleWildcardIdx == -1 && depth - 1 >= this.components.length) {
                return false;
            }
            int idx = depth - 1;
            if (this.firstDoubleWildcardIdx != -1 && idx >= this.firstDoubleWildcardIdx) {
                return true;
            }
            if (idx >= 0 && idx < this.components.length) {
                return this.components[idx].matches(currentName);
            }
            return false;
        }
    }

    private static class GlobComponent {
        final boolean isDoubleWildcard;
        final boolean isExact;
        final char[] pattern;
        final String patternStr;
        final PathMatcher complexMatcher;
        final boolean isCaseInsensitive;
        final FileSystem fs;

        GlobComponent(String patternStr, FileSystem fs, boolean isCaseInsensitive) {
            this.fs = fs;
            this.patternStr = patternStr;
            this.isCaseInsensitive = isCaseInsensitive;
            this.isDoubleWildcard = patternStr.equals("**");
            this.pattern = patternStr.toCharArray();
            boolean hasSimpleMeta = false;
            boolean hasComplex = false;
            for (char c : this.pattern) {
                if (c == '*' || c == '?') {
                    hasSimpleMeta = true;
                    continue;
                }
                if (c != '[' && c != '{' && c != '\\') continue;
                hasSimpleMeta = true;
                hasComplex = true;
            }
            this.isExact = !hasSimpleMeta;
            this.complexMatcher = hasComplex ? fs.getPathMatcher("glob:" + patternStr) : null;
        }

        boolean matches(String text) {
            if (this.isDoubleWildcard) {
                return true;
            }
            if (this.complexMatcher != null) {
                return this.complexMatcher.matches(this.fs.getPath(text, new String[0]));
            }
            if (this.isExact) {
                return this.isCaseInsensitive ? text.equalsIgnoreCase(this.patternStr) : text.equals(this.patternStr);
            }
            return GlobComponent.fastGlobMatch(this.pattern, text, this.isCaseInsensitive);
        }

        private static boolean fastGlobMatch(char[] p, String t, boolean caseInsensitive) {
            int tLen = t.length();
            int pLen = p.length;
            int tIdx = 0;
            int pIdx = 0;
            int starIdx = -1;
            int matchIdx = -1;
            while (tIdx < tLen) {
                boolean charsMatch;
                char tc = t.charAt(tIdx);
                char pc = pIdx < pLen ? p[pIdx] : (char)'\u0000';
                boolean isSlashMismatch = pc == '/' && tc == '\\';
                boolean bl = charsMatch = pc == tc || isSlashMismatch || caseInsensitive && Character.toLowerCase(pc) == Character.toLowerCase(tc);
                if (pIdx < pLen && (pc == '?' || charsMatch)) {
                    ++pIdx;
                    ++tIdx;
                    continue;
                }
                if (pIdx < pLen && pc == '*') {
                    starIdx = pIdx++;
                    matchIdx = tIdx;
                    continue;
                }
                if (starIdx != -1) {
                    pIdx = starIdx + 1;
                    tIdx = ++matchIdx;
                    continue;
                }
                return false;
            }
            while (pIdx < pLen && p[pIdx] == '*') {
                ++pIdx;
            }
            return pIdx == pLen;
        }
    }
}

