/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.List;
import java.util.Map;
import pl.skidam.automodpack_core.protocol.netty.NettyServer;
import pl.skidam.automodpack_core.protocol.netty.handler.ProtocolMessageDecoder;
import pl.skidam.automodpack_core.protocol.netty.handler.ServerMessageHandler;
import pl.skidam.automodpack_core.protocol.netty.handler.ZstdDecoder;
import pl.skidam.automodpack_core.protocol.netty.handler.ZstdEncoder;

public class ProtocolServerHandler
extends ByteToMessageDecoder {
    private final SslContext sslCtx;

    public ProtocolServerHandler(SslContext sslCtx) {
        this.sslCtx = sslCtx;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            if (in.readableBytes() < 4) {
                return;
            }
            int magic = in.getInt(0);
            if (magic == 1095585091) {
                in.skipBytes(in.readableBytes());
                ByteBuf response = ctx.alloc().buffer(4);
                response.writeInt(1095585611);
                ctx.writeAndFlush((Object)response);
                Map handlers = ctx.pipeline().toMap();
                handlers.forEach((name, handler) -> ctx.pipeline().remove(handler));
                ctx.pipeline().channel().attr(NettyServer.USE_COMPRESSION).set((Object)true);
                ctx.pipeline().addLast("tls", (ChannelHandler)this.sslCtx.newHandler(ctx.alloc()));
                ctx.pipeline().addLast("zstd-encoder", (ChannelHandler)new ZstdEncoder());
                ctx.pipeline().addLast("zstd-decoder", (ChannelHandler)new ZstdDecoder());
                ctx.pipeline().addLast("chunked-write", (ChannelHandler)new ChunkedWriteHandler());
                ctx.pipeline().addLast("protocol-msg-decoder", (ChannelHandler)new ProtocolMessageDecoder());
                ctx.pipeline().addLast("msg-handler", (ChannelHandler)new ServerMessageHandler());
            }
            if (ctx.pipeline().get(((Object)((Object)this)).getClass()) != null) {
                ctx.pipeline().remove((ChannelHandler)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

