/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.oer.its.ieee1609dot2.basetypes;

import amp_libs.org.bouncycastle.asn1.ASN1Object;
import amp_libs.org.bouncycastle.asn1.ASN1OctetString;
import amp_libs.org.bouncycastle.asn1.ASN1Primitive;
import amp_libs.org.bouncycastle.asn1.ASN1Sequence;
import amp_libs.org.bouncycastle.asn1.DEROctetString;
import amp_libs.org.bouncycastle.oer.its.ItsUtils;
import amp_libs.org.bouncycastle.oer.its.ieee1609dot2.basetypes.EccP256CurvePoint;
import amp_libs.org.bouncycastle.util.Arrays;

public class EcdsaP256Signature
extends ASN1Object {
    private final EccP256CurvePoint rSig;
    private final ASN1OctetString sSig;

    public EcdsaP256Signature(EccP256CurvePoint eccP256CurvePoint, ASN1OctetString aSN1OctetString) {
        this.rSig = eccP256CurvePoint;
        this.sSig = aSN1OctetString;
    }

    private EcdsaP256Signature(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("expected sequence size of 2");
        }
        this.rSig = EccP256CurvePoint.getInstance(aSN1Sequence.getObjectAt(0));
        this.sSig = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public static EcdsaP256Signature getInstance(Object object) {
        if (object instanceof EcdsaP256Signature) {
            return (EcdsaP256Signature)object;
        }
        if (object != null) {
            return new EcdsaP256Signature(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public EccP256CurvePoint getRSig() {
        return this.rSig;
    }

    public ASN1OctetString getSSig() {
        return this.sSig;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return ItsUtils.toSequence(this.rSig, this.sSig);
    }

    public static class Builder {
        private EccP256CurvePoint rSig;
        private ASN1OctetString sSig;

        public Builder setRSig(EccP256CurvePoint eccP256CurvePoint) {
            this.rSig = eccP256CurvePoint;
            return this;
        }

        public Builder setSSig(byte[] byArray) {
            this.sSig = new DEROctetString(Arrays.clone(byArray));
            return this;
        }

        public Builder setSSig(ASN1OctetString aSN1OctetString) {
            this.sSig = aSN1OctetString;
            return this;
        }

        public EcdsaP256Signature createEcdsaP256Signature() {
            return new EcdsaP256Signature(this.rSig, this.sSig);
        }
    }
}

