/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.netty.handler;

import com.github.luben.zstd.Zstd;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import pl.skidam.automodpack_core.protocol.netty.NettyServer;

public class ZstdDecoder
extends ByteToMessageDecoder {
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!((Boolean)ctx.pipeline().channel().attr(NettyServer.USE_COMPRESSION).get()).booleanValue()) {
            if (in.readableBytes() < 4) {
                return;
            }
            int length = in.readInt();
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
                return;
            }
            ByteBuf buf = in.readBytes(length);
            out.add(buf);
            return;
        }
        if (in.readableBytes() < 8) {
            return;
        }
        int compressedLength = in.readInt();
        int originalLength = in.readInt();
        if (compressedLength < 0 || originalLength < 0) {
            throw new IllegalArgumentException("Invalid compressed or original length");
        }
        if (originalLength > 131072) {
            throw new IllegalArgumentException("Original length exceeds maximum packet size");
        }
        if (in.readableBytes() < compressedLength) {
            in.resetReaderIndex();
            return;
        }
        byte[] compressed = new byte[compressedLength];
        in.readBytes(compressed);
        byte[] decompressed = Zstd.decompress(compressed, originalLength);
        if (decompressed.length != originalLength) {
            throw new IllegalStateException("Decompressed length does not match original length");
        }
        ByteBuf decompressedBuf = ctx.alloc().buffer(originalLength);
        decompressedBuf.writeBytes(decompressed);
        out.add(decompressedBuf);
    }
}

