/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import pl.skidam.automodpack_core.GlobalVariables;

public class WildCards {
    private final Map<String, Path> wildcardMatches = new HashMap<String, Path>();
    private final Map<String, Path> wildcardBlackListed = new HashMap<String, Path>();

    public WildCards(List<String> wildcardsList, Set<Path> directoriesToSearch) {
        if (directoriesToSearch.isEmpty()) {
            return;
        }
        ArrayList<String> normalWildcards = new ArrayList<String>();
        ArrayList<String> blacklistedWildcards = new ArrayList<String>();
        for (String string : wildcardsList) {
            if (string.startsWith("!")) {
                blacklistedWildcards.add(string);
                continue;
            }
            normalWildcards.add(string);
        }
        boolean usingFullPaths = false;
        for (Path path : directoriesToSearch) {
            for (String string : normalWildcards) {
                if (!string.contains(path.toString())) continue;
                usingFullPaths = true;
                break;
            }
            if (!usingFullPaths) continue;
            break;
        }
        if (usingFullPaths) {
            ArrayList<String> arrayList = new ArrayList<String>();
            block3: for (String wildcard : normalWildcards) {
                for (Path dir : directoriesToSearch) {
                    String dirStr = dir.toString().replace(File.separator, "/");
                    if (!wildcard.contains(dirStr)) continue;
                    String relativePath = wildcard.substring(wildcard.indexOf(dirStr) + dirStr.length());
                    arrayList.add(relativePath);
                    continue block3;
                }
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            block5: for (String string : blacklistedWildcards) {
                for (Path dir : directoriesToSearch) {
                    String dirStr = dir.toString().replace(File.separator, "/");
                    if (!string.contains(dirStr)) continue;
                    String relativePath = string.substring(string.indexOf(dirStr) + dirStr.length());
                    arrayList2.add("!" + relativePath);
                    continue block5;
                }
            }
            this.processWildcards(arrayList, directoriesToSearch, false);
            this.processWildcards(arrayList2, directoriesToSearch, true);
        } else {
            this.processWildcards(normalWildcards, directoriesToSearch, false);
            this.processWildcards(blacklistedWildcards, directoriesToSearch, true);
        }
    }

    private void processWildcards(List<String> wildcardsList, Set<Path> directoriesToSearch, boolean blackListed) {
        for (String wildcard : wildcardsList) {
            String filePart;
            String dirPart;
            if (blackListed) {
                wildcard = wildcard.substring(1);
            }
            String wildcardPathStr = wildcard.replace(File.separator, "/");
            boolean startsWithSlash = wildcardPathStr.startsWith("/");
            if (wildcardPathStr.contains("/")) {
                int lastSlashIndex = wildcardPathStr.lastIndexOf(47);
                if (lastSlashIndex == 0) {
                    dirPart = "";
                    filePart = wildcardPathStr.substring(1);
                } else {
                    dirPart = wildcardPathStr.substring(0, lastSlashIndex);
                    filePart = wildcardPathStr.substring(lastSlashIndex + 1);
                }
            } else {
                dirPart = "";
                filePart = wildcardPathStr;
            }
            if (dirPart.contains("*")) {
                GlobalVariables.LOGGER.warn("Wildcard: \"{}\" contains '*' in a directory, which is not supported. Wildcards only works with filenames not directories.", (Object)wildcard);
                continue;
            }
            String sysDirPart = dirPart.replace("/", File.separator);
            if (sysDirPart.startsWith(File.separator)) {
                sysDirPart = sysDirPart.substring(1);
            }
            for (Path pathToSearch : directoriesToSearch) {
                Path dirPath = sysDirPart.isEmpty() ? pathToSearch : (sysDirPart.contains(pathToSearch.toString()) ? Path.of(sysDirPart, new String[0]) : pathToSearch.resolve(sysDirPart));
                if (!(Files.exists(dirPath, new LinkOption[0]) && Files.isDirectory(dirPath, new LinkOption[0]) || !wildcardPathStr.contains(pathToSearch.toString().replace(File.separator, "/")))) {
                    String relativePath = wildcardPathStr.substring(wildcardPathStr.indexOf(pathToSearch.toString().replace(File.separator, "/")) + pathToSearch.toString().length());
                    if (relativePath.startsWith("/")) {
                        relativePath = relativePath.substring(1);
                    }
                    relativePath = relativePath.contains("/") ? relativePath.substring(0, relativePath.lastIndexOf(47)) : "";
                    relativePath = relativePath.replace("/", File.separator);
                    dirPath = pathToSearch.resolve(relativePath);
                }
                if (!Files.exists(dirPath, new LinkOption[0]) || !Files.isDirectory(dirPath, new LinkOption[0])) continue;
                try {
                    this.processDirectory(dirPath, filePart, wildcard, startsWithSlash, blackListed, pathToSearch);
                }
                catch (IOException e) {
                    GlobalVariables.LOGGER.error("Error occurred while processing directory for wildcard: {} path: {}", (Object)wildcard, (Object)dirPath, (Object)e);
                }
            }
        }
    }

    private void processDirectory(Path dirPath, String filePart, String wildcard, boolean startsWithSlash, boolean blackListed, Path rootPath) throws IOException {
        if (filePart.contains("**")) {
            this.processRecursively(dirPath, wildcard, startsWithSlash, blackListed, rootPath);
        } else {
            try (Stream<Path> files = Files.list(dirPath);){
                files.forEach(childPath -> {
                    if (Files.isDirectory(childPath, new LinkOption[0])) {
                        try {
                            if (wildcard.contains("**")) {
                                this.processDirectory((Path)childPath, filePart, wildcard, startsWithSlash, blackListed, rootPath);
                            }
                        }
                        catch (IOException e) {
                            GlobalVariables.LOGGER.error("Error occurred while processing directory: {}", childPath, (Object)e);
                        }
                    } else {
                        Object relativePath = rootPath.relativize((Path)childPath).toString().replace(File.separator, "/");
                        if (startsWithSlash) {
                            relativePath = "/" + (String)relativePath;
                        }
                        if (this.fileMatches((String)relativePath, wildcard)) {
                            if (blackListed) {
                                this.wildcardMatches.remove(relativePath);
                                this.wildcardBlackListed.put((String)relativePath, (Path)childPath);
                            } else if (!this.wildcardBlackListed.containsKey(relativePath) && Files.exists(childPath, new LinkOption[0]) && !Files.isDirectory(childPath, new LinkOption[0])) {
                                this.wildcardMatches.put((String)relativePath, (Path)childPath);
                            }
                        }
                    }
                });
            }
        }
    }

    private void processRecursively(Path dirPath, String wildcard, boolean startsWithSlash, boolean blackListed, Path rootPath) throws IOException {
        try (Stream<Path> files = Files.list(dirPath);){
            files.forEach(childPath -> {
                Object relativePath = rootPath.relativize((Path)childPath).toString().replace(File.separator, "/");
                if (startsWithSlash) {
                    relativePath = "/" + (String)relativePath;
                }
                if (Files.isDirectory(childPath, new LinkOption[0])) {
                    try {
                        this.processRecursively((Path)childPath, wildcard, startsWithSlash, blackListed, rootPath);
                    }
                    catch (IOException e) {
                        GlobalVariables.LOGGER.error("Error occurred while processing directory recursively: {}", childPath, (Object)e);
                    }
                } else if (this.fileMatches((String)relativePath, wildcard)) {
                    if (blackListed) {
                        this.wildcardMatches.remove(relativePath);
                        this.wildcardBlackListed.put((String)relativePath, (Path)childPath);
                    } else if (!this.wildcardBlackListed.containsKey(relativePath) && Files.exists(childPath, new LinkOption[0]) && !Files.isDirectory(childPath, new LinkOption[0])) {
                        this.wildcardMatches.put((String)relativePath, (Path)childPath);
                    }
                }
            });
        }
    }

    private boolean fileMatches(String file, String wildCardString) {
        String wildcardFileName;
        file = file.replace(File.separator, "/");
        if ((wildCardString = wildCardString.replace(File.separator, "/")).contains(file)) {
            return true;
        }
        if (!wildCardString.contains("*") && file.endsWith(wildCardString.startsWith("/") ? wildCardString.substring(1) : wildCardString)) {
            return true;
        }
        String fileName = file.contains("/") ? file.substring(file.lastIndexOf(47) + 1) : file;
        String string = wildcardFileName = wildCardString.contains("/") ? wildCardString.substring(wildCardString.lastIndexOf(47) + 1) : wildCardString;
        if (!wildcardFileName.contains("*")) {
            return fileName.equals(wildcardFileName);
        }
        if (wildCardString.contains("**")) {
            String[] parts = wildCardString.split("\\*\\*");
            if (parts.length == 0) {
                return true;
            }
            int startIndex = 0;
            for (String part : parts) {
                int currentIndex = file.indexOf(part, startIndex);
                if (currentIndex == -1) {
                    return false;
                }
                startIndex = currentIndex + part.length();
            }
            return true;
        }
        String[] wildcardParts = wildCardString.split("\\*");
        boolean startsWithWildcard = wildCardString.startsWith("*");
        int startIndex = 0;
        for (int i = 0; i < wildcardParts.length; ++i) {
            String part = wildcardParts[i];
            if (part.isEmpty()) continue;
            if (i == 0 && !startsWithWildcard) {
                if (file.startsWith(part)) {
                    startIndex = part.length();
                    continue;
                }
                if (file.endsWith(part)) {
                    return true;
                }
                int index = file.indexOf(part);
                if (index != -1) {
                    startIndex = index + part.length();
                    continue;
                }
                return false;
            }
            int currentIndex = file.indexOf(part, startIndex);
            if (currentIndex == -1) {
                return false;
            }
            startIndex = currentIndex + part.length();
        }
        return wildCardString.endsWith("*") || file.endsWith(wildcardParts[wildcardParts.length - 1]);
    }

    public boolean fileMatches(String path, Path file) {
        return this.wildcardMatches.containsKey(path) || this.wildcardMatches.containsValue(file);
    }

    public Map<String, Path> getWildcardMatches() {
        return this.wildcardMatches;
    }

    public boolean fileBlackListed(String path, Path file) {
        return this.wildcardBlackListed.containsKey(path) || this.wildcardBlackListed.containsValue(file);
    }

    public Map<String, Path> getWildcardBlackListed() {
        return this.wildcardBlackListed;
    }
}

