/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.pkcs;

import am_libs.org.bouncycastle.asn1.pkcs.MacData;
import am_libs.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import am_libs.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import am_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import am_libs.org.bouncycastle.asn1.x509.DigestInfo;
import am_libs.org.bouncycastle.operator.MacCalculator;
import am_libs.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import am_libs.org.bouncycastle.pkcs.PKCSException;
import am_libs.org.bouncycastle.util.Strings;
import java.io.OutputStream;

class MacDataGenerator {
    private PKCS12MacCalculatorBuilder builder;

    MacDataGenerator(PKCS12MacCalculatorBuilder pKCS12MacCalculatorBuilder) {
        this.builder = pKCS12MacCalculatorBuilder;
    }

    public MacData build(char[] cArray, byte[] byArray) throws PKCSException {
        int n;
        byte[] byArray2;
        Object object;
        MacCalculator macCalculator;
        try {
            macCalculator = this.builder.build(cArray);
            object = macCalculator.getOutputStream();
            ((OutputStream)object).write(byArray);
            ((OutputStream)object).close();
        }
        catch (Exception exception) {
            throw new PKCSException("unable to process data: " + exception.getMessage(), exception);
        }
        object = macCalculator.getAlgorithmIdentifier();
        DigestInfo digestInfo = new DigestInfo(this.builder.getDigestAlgorithmIdentifier(), macCalculator.getMac());
        if (PKCSObjectIdentifiers.id_PBMAC1.equals(digestInfo.getAlgorithmId().getAlgorithm())) {
            byArray2 = Strings.toUTF8ByteArray("NOT USED".toCharArray());
            n = 1;
        } else {
            PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(((AlgorithmIdentifier)object).getParameters());
            byArray2 = pKCS12PBEParams.getIV();
            n = pKCS12PBEParams.getIterations().intValue();
        }
        return new MacData(digestInfo, byArray2, n);
    }
}

