/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.protocol.netty.NettyServer;
import pl.skidam.automodpack_core.protocol.netty.message.configuration.ConfigurationChunkSizeMessage;
import pl.skidam.automodpack_core.protocol.netty.message.configuration.ConfigurationCompressionMessage;
import pl.skidam.automodpack_core.protocol.netty.message.configuration.UnknownConfigurationMessage;
import pl.skidam.automodpack_core.utils.PlatformUtils;

public class ConfigurationHandler
extends ChannelInboundHandlerAdapter {
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            ctx.fireChannelRead(msg);
            return;
        }
        ByteBuf in = (ByteBuf)msg;
        in.markReaderIndex();
        GlobalVariables.LOGGER.debug("Received a message (checking for configuration) with {} readable bytes", (Object)in.readableBytes());
        if (in.readableBytes() < 2) {
            return;
        }
        byte version = in.readByte();
        byte type = in.readByte();
        GlobalVariables.LOGGER.debug("Message version: {}, type: {}, readable bytes: {}", (Object)version, (Object)type, (Object)in.readableBytes());
        if ((type & 0xF0) == 64) {
            if (type == 64) {
                ctx.pipeline().remove((ChannelHandler)this);
                GlobalVariables.LOGGER.debug("Removed ConfigurationHandler from pipeline after receiving echo configuration message.");
            } else if (type == 65) {
                byte negotiatedCompressionType;
                if (in.readableBytes() < 1) {
                    in.resetReaderIndex();
                    return;
                }
                byte clientCompressionType = in.readByte();
                if (PlatformUtils.isAndroid() && clientCompressionType == 1) {
                    negotiatedCompressionType = 2;
                    GlobalVariables.LOGGER.warn("Client requested Zstd compression but we don't support it; falling back to Gzip.");
                } else {
                    negotiatedCompressionType = clientCompressionType == 1 || clientCompressionType == 2 || clientCompressionType == 0 ? (byte)clientCompressionType : (byte)1;
                }
                ctx.channel().attr(NettyServer.COMPRESSION_TYPE).set((Object)negotiatedCompressionType);
                ConfigurationCompressionMessage responseMsg = new ConfigurationCompressionMessage(1, negotiatedCompressionType);
                ctx.writeAndFlush((Object)responseMsg.toByteBuf());
                GlobalVariables.LOGGER.debug("Negotiated configuration: compression {}", (Object)negotiatedCompressionType);
            } else if (type == 66) {
                if (in.readableBytes() < 4) {
                    in.resetReaderIndex();
                    return;
                }
                int clientChunkSize = in.readInt();
                int negotiatedChunkSize = clientChunkSize >= 8192 && clientChunkSize <= 524288 ? clientChunkSize : 131072;
                ctx.channel().attr(NettyServer.CHUNK_SIZE).set((Object)negotiatedChunkSize);
                ConfigurationChunkSizeMessage responseMsg = new ConfigurationChunkSizeMessage(1, negotiatedChunkSize);
                ctx.writeAndFlush((Object)responseMsg.toByteBuf());
                GlobalVariables.LOGGER.debug("Negotiated configuration: chunk size {}", (Object)negotiatedChunkSize);
            } else {
                GlobalVariables.LOGGER.debug("Received unknown configuration message type: {} version: {}", (Object)type, (Object)version);
                UnknownConfigurationMessage responseMsg = new UnknownConfigurationMessage(1);
                ctx.writeAndFlush((Object)responseMsg.toByteBuf());
            }
            in.release();
        } else {
            GlobalVariables.LOGGER.debug("Received non-configuration message of type: {} version: {}", (Object)type, (Object)version);
            in.resetReaderIndex();
            ctx.fireChannelRead((Object)in);
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }
}

