/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.crypto.digests;

import am_libs.org.bouncycastle.crypto.CryptoServiceProperties;
import am_libs.org.bouncycastle.crypto.CryptoServicePurpose;
import am_libs.org.bouncycastle.crypto.Digest;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Utils {
    Utils() {
    }

    static CryptoServiceProperties getDefaultProperties(Digest digest, CryptoServicePurpose cryptoServicePurpose) {
        return new DefaultProperties(digest.getDigestSize() * 4, digest.getAlgorithmName(), cryptoServicePurpose);
    }

    static CryptoServiceProperties getDefaultProperties(Digest digest, int n, CryptoServicePurpose cryptoServicePurpose) {
        return new DefaultPropertiesWithPRF(digest.getDigestSize() * 4, n, digest.getAlgorithmName(), cryptoServicePurpose);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DefaultProperties
    implements CryptoServiceProperties {
        private final int bitsOfSecurity;
        private final String algorithmName;
        private final CryptoServicePurpose purpose;

        public DefaultProperties(int n, String string, CryptoServicePurpose cryptoServicePurpose) {
            this.bitsOfSecurity = n;
            this.algorithmName = string;
            this.purpose = cryptoServicePurpose;
        }

        @Override
        public int bitsOfSecurity() {
            return this.bitsOfSecurity;
        }

        @Override
        public String getServiceName() {
            return this.algorithmName;
        }

        @Override
        public CryptoServicePurpose getPurpose() {
            return this.purpose;
        }

        @Override
        public Object getParams() {
            return null;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DefaultPropertiesWithPRF
    implements CryptoServiceProperties {
        private final int bitsOfSecurity;
        private final int prfBitsOfSecurity;
        private final String algorithmName;
        private final CryptoServicePurpose purpose;

        public DefaultPropertiesWithPRF(int n, int n2, String string, CryptoServicePurpose cryptoServicePurpose) {
            this.bitsOfSecurity = n;
            this.prfBitsOfSecurity = n2;
            this.algorithmName = string;
            this.purpose = cryptoServicePurpose;
        }

        @Override
        public int bitsOfSecurity() {
            if (this.purpose == CryptoServicePurpose.PRF) {
                return this.prfBitsOfSecurity;
            }
            return this.bitsOfSecurity;
        }

        @Override
        public String getServiceName() {
            return this.algorithmName;
        }

        @Override
        public CryptoServicePurpose getPurpose() {
            return this.purpose;
        }

        @Override
        public Object getParams() {
            return null;
        }
    }
}

