/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.apache.hc.core5.http.impl.nio;

import am_libs.org.apache.hc.core5.http.HttpException;
import am_libs.org.apache.hc.core5.http.HttpResponse;
import am_libs.org.apache.hc.core5.http.HttpResponseFactory;
import am_libs.org.apache.hc.core5.http.config.Http1Config;
import am_libs.org.apache.hc.core5.http.impl.nio.AbstractMessageParser;
import am_libs.org.apache.hc.core5.http.message.LineParser;
import am_libs.org.apache.hc.core5.http.message.StatusLine;
import am_libs.org.apache.hc.core5.util.Args;
import am_libs.org.apache.hc.core5.util.CharArrayBuffer;

public class DefaultHttpResponseParser<T extends HttpResponse>
extends AbstractMessageParser<T> {
    private final HttpResponseFactory<T> responseFactory;

    public DefaultHttpResponseParser(Http1Config http1Config, LineParser parser, HttpResponseFactory<T> responseFactory) {
        super(http1Config, parser);
        this.responseFactory = Args.notNull(responseFactory, "Response factory");
    }

    public DefaultHttpResponseParser(Http1Config http1Config, HttpResponseFactory<T> responseFactory) {
        this(http1Config, null, responseFactory);
    }

    @Deprecated
    public DefaultHttpResponseParser(HttpResponseFactory<T> responseFactory, LineParser parser, Http1Config http1Config) {
        this(http1Config, parser, responseFactory);
    }

    @Deprecated
    public DefaultHttpResponseParser(HttpResponseFactory<T> responseFactory, Http1Config http1Config) {
        this(responseFactory, null, http1Config);
    }

    public DefaultHttpResponseParser(HttpResponseFactory<T> responseFactory) {
        this(null, null, responseFactory);
    }

    @Override
    protected T createMessage(CharArrayBuffer buffer) throws HttpException {
        StatusLine statusLine = this.getLineParser().parseStatusLine(buffer);
        T response = this.responseFactory.newHttpResponse(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        response.setVersion(statusLine.getProtocolVersion());
        return response;
    }
}

