/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.apache.hc.core5.http2.impl.nio;

import amp_libs.org.apache.hc.core5.annotation.Contract;
import amp_libs.org.apache.hc.core5.annotation.Internal;
import amp_libs.org.apache.hc.core5.annotation.ThreadingBehavior;
import amp_libs.org.apache.hc.core5.function.Callback;
import amp_libs.org.apache.hc.core5.http.URIScheme;
import amp_libs.org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import amp_libs.org.apache.hc.core5.http.impl.nio.ServerHttp1IOEventHandler;
import amp_libs.org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import amp_libs.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import amp_libs.org.apache.hc.core5.http2.HttpVersionPolicy;
import amp_libs.org.apache.hc.core5.http2.impl.nio.HttpProtocolNegotiator;
import amp_libs.org.apache.hc.core5.http2.impl.nio.ServerH2PrefaceHandler;
import amp_libs.org.apache.hc.core5.http2.impl.nio.ServerH2StreamMultiplexerFactory;
import amp_libs.org.apache.hc.core5.http2.impl.nio.ServerH2UpgradeHandler;
import amp_libs.org.apache.hc.core5.http2.impl.nio.ServerHttp1UpgradeHandler;
import amp_libs.org.apache.hc.core5.http2.ssl.ApplicationProtocol;
import amp_libs.org.apache.hc.core5.reactor.EndpointParameters;
import amp_libs.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import amp_libs.org.apache.hc.core5.reactor.ProtocolIOSession;
import amp_libs.org.apache.hc.core5.util.Args;
import amp_libs.org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ServerHttpProtocolNegotiationStarter
implements IOEventHandlerFactory {
    private final ServerHttp1StreamDuplexerFactory http1StreamHandlerFactory;
    private final ServerH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;
    private final Callback<Exception> exceptionCallback;

    public ServerHttpProtocolNegotiationStarter(ServerHttp1StreamDuplexerFactory http1StreamHandlerFactory, ServerH2StreamMultiplexerFactory http2StreamHandlerFactory, HttpVersionPolicy versionPolicy, TlsStrategy tlsStrategy, Timeout handshakeTimeout, Callback<Exception> exceptionCallback) {
        this.http1StreamHandlerFactory = Args.notNull(http1StreamHandlerFactory, "HTTP/1.1 stream handler factory");
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = handshakeTimeout;
        this.exceptionCallback = exceptionCallback;
    }

    @Override
    public HttpConnectionEventHandler createHandler(ProtocolIOSession ioSession, Object attachment) {
        HttpVersionPolicy endpointPolicy = this.versionPolicy;
        URIScheme uriScheme = URIScheme.HTTP;
        if (attachment instanceof EndpointParameters) {
            EndpointParameters params = (EndpointParameters)attachment;
            if (this.tlsStrategy != null && URIScheme.HTTPS.same(params.getScheme())) {
                uriScheme = URIScheme.HTTPS;
                this.tlsStrategy.upgrade(ioSession, params, params.getAttachment(), this.handshakeTimeout, null);
            }
            if (params.getAttachment() instanceof HttpVersionPolicy) {
                endpointPolicy = (HttpVersionPolicy)((Object)params.getAttachment());
            }
        }
        ioSession.registerProtocol(ApplicationProtocol.HTTP_1_1.id, new ServerHttp1UpgradeHandler(this.http1StreamHandlerFactory));
        ioSession.registerProtocol(ApplicationProtocol.HTTP_2.id, new ServerH2UpgradeHandler(this.http2StreamHandlerFactory, this.exceptionCallback));
        switch (endpointPolicy) {
            case FORCE_HTTP_2: {
                return new ServerH2PrefaceHandler(ioSession, this.http2StreamHandlerFactory, this.exceptionCallback);
            }
            case FORCE_HTTP_1: {
                return new ServerHttp1IOEventHandler(this.http1StreamHandlerFactory.create(uriScheme.id, ioSession));
            }
        }
        return new HttpProtocolNegotiator(ioSession, null);
    }
}

