/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.pkcs.bc;

import amp_libs.org.bouncycastle.asn1.pkcs.PBMAC1Params;
import amp_libs.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import amp_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import amp_libs.org.bouncycastle.operator.MacCalculator;
import amp_libs.org.bouncycastle.operator.OperatorCreationException;
import amp_libs.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import amp_libs.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import amp_libs.org.bouncycastle.pkcs.bc.BcPKCS12PBMac1CalculatorBuilder;
import java.io.IOException;

public class BcPKCS12PBMac1CalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    @Override
    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            @Override
            public MacCalculator build(char[] cArray) throws OperatorCreationException {
                BcPKCS12PBMac1CalculatorBuilder bcPKCS12PBMac1CalculatorBuilder;
                if (!PKCSObjectIdentifiers.id_PBMAC1.equals(algorithmIdentifier.getAlgorithm())) {
                    throw new OperatorCreationException("protection algorithm not PB mac based");
                }
                try {
                    bcPKCS12PBMac1CalculatorBuilder = new BcPKCS12PBMac1CalculatorBuilder(PBMAC1Params.getInstance(algorithmIdentifier.getParameters()));
                }
                catch (IOException iOException) {
                    throw new OperatorCreationException("invalid parameters in protection algorithm: " + iOException.getMessage());
                }
                return bcPKCS12PBMac1CalculatorBuilder.build(cArray);
            }

            @Override
            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), algorithmIdentifier.getParameters());
            }
        };
    }
}

