/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.apache.hc.client5.http.impl.compat;

import amp_libs.org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import amp_libs.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import amp_libs.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import amp_libs.org.apache.hc.client5.http.impl.compat.ClassicToAsyncRequestProducer;
import amp_libs.org.apache.hc.client5.http.impl.compat.ClassicToAsyncResponseConsumer;
import amp_libs.org.apache.hc.core5.annotation.Contract;
import amp_libs.org.apache.hc.core5.annotation.Experimental;
import amp_libs.org.apache.hc.core5.annotation.Internal;
import amp_libs.org.apache.hc.core5.annotation.ThreadingBehavior;
import amp_libs.org.apache.hc.core5.concurrent.CancellableDependency;
import amp_libs.org.apache.hc.core5.http.ClassicHttpRequest;
import amp_libs.org.apache.hc.core5.http.ClassicHttpResponse;
import amp_libs.org.apache.hc.core5.http.HttpHost;
import amp_libs.org.apache.hc.core5.http.protocol.HttpContext;
import amp_libs.org.apache.hc.core5.io.CloseMode;
import amp_libs.org.apache.hc.core5.util.Timeout;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.Future;

@Experimental
@Internal
@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class ClassicToAsyncAdaptor
extends CloseableHttpClient {
    private final CloseableHttpAsyncClient client;
    private final Timeout operationTimeout;

    public ClassicToAsyncAdaptor(CloseableHttpAsyncClient client, Timeout operationTimeout) {
        this.client = client;
        this.operationTimeout = operationTimeout;
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, ClassicHttpRequest request, HttpContext context) throws IOException {
        ClassicToAsyncRequestProducer requestProducer = new ClassicToAsyncRequestProducer(request, this.operationTimeout);
        ClassicToAsyncResponseConsumer responseConsumer = new ClassicToAsyncResponseConsumer(this.operationTimeout);
        Future<Void> resultFuture = this.client.execute(target, requestProducer, responseConsumer, null, context, null);
        if (request instanceof CancellableDependency) {
            ((CancellableDependency)((Object)request)).setDependency(() -> resultFuture.cancel(true));
        }
        try {
            requestProducer.blockWaiting().execute();
            ClassicHttpResponse response = responseConsumer.blockWaiting();
            return CloseableHttpResponse.create(response, (closeable, closeMode) -> {
                try {
                    if (closeMode == CloseMode.GRACEFUL) {
                        closeable.close();
                    }
                }
                finally {
                    resultFuture.cancel(true);
                }
            });
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.client.close(closeMode);
    }
}

