/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.apache.hc.core5.http.impl.io;

import amp_libs.org.apache.hc.core5.http.ClassicHttpRequest;
import amp_libs.org.apache.hc.core5.http.HttpException;
import amp_libs.org.apache.hc.core5.http.HttpRequestFactory;
import amp_libs.org.apache.hc.core5.http.MessageConstraintException;
import amp_libs.org.apache.hc.core5.http.RequestHeaderFieldsTooLargeException;
import amp_libs.org.apache.hc.core5.http.config.Http1Config;
import amp_libs.org.apache.hc.core5.http.impl.io.AbstractMessageParser;
import amp_libs.org.apache.hc.core5.http.impl.io.DefaultClassicHttpRequestFactory;
import amp_libs.org.apache.hc.core5.http.io.SessionInputBuffer;
import amp_libs.org.apache.hc.core5.http.message.LineParser;
import amp_libs.org.apache.hc.core5.http.message.RequestLine;
import amp_libs.org.apache.hc.core5.util.CharArrayBuffer;
import java.io.IOException;
import java.io.InputStream;

public class DefaultHttpRequestParser
extends AbstractMessageParser<ClassicHttpRequest> {
    private final HttpRequestFactory<ClassicHttpRequest> requestFactory;

    public DefaultHttpRequestParser(Http1Config http1Config, LineParser lineParser, HttpRequestFactory<ClassicHttpRequest> requestFactory) {
        super(http1Config, lineParser);
        this.requestFactory = requestFactory != null ? requestFactory : DefaultClassicHttpRequestFactory.INSTANCE;
    }

    @Deprecated
    public DefaultHttpRequestParser(LineParser lineParser, HttpRequestFactory<ClassicHttpRequest> requestFactory, Http1Config http1Config) {
        this(http1Config, lineParser, requestFactory);
    }

    public DefaultHttpRequestParser(Http1Config http1Config) {
        this(http1Config, null, null);
    }

    public DefaultHttpRequestParser() {
        this(Http1Config.DEFAULT, null, null);
    }

    @Override
    public ClassicHttpRequest parse(SessionInputBuffer buffer, InputStream inputStream) throws IOException, HttpException {
        try {
            return (ClassicHttpRequest)super.parse(buffer, inputStream);
        }
        catch (MessageConstraintException ex) {
            throw new RequestHeaderFieldsTooLargeException(ex.getMessage(), ex);
        }
    }

    @Override
    protected ClassicHttpRequest createMessage(CharArrayBuffer buffer) throws IOException, HttpException {
        RequestLine requestLine = this.getLineParser().parseRequestLine(buffer);
        ClassicHttpRequest request = this.requestFactory.newHttpRequest(requestLine.getMethod(), requestLine.getUri());
        request.setVersion(requestLine.getProtocolVersion());
        return request;
    }
}

