/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.crypto.signers;

import amp_libs.org.bouncycastle.crypto.CipherParameters;
import amp_libs.org.bouncycastle.crypto.CryptoServiceProperties;
import amp_libs.org.bouncycastle.crypto.CryptoServicePurpose;
import amp_libs.org.bouncycastle.crypto.constraints.ConstraintUtils;
import amp_libs.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import amp_libs.org.bouncycastle.crypto.params.DSAKeyParameters;
import amp_libs.org.bouncycastle.crypto.params.ECKeyParameters;
import amp_libs.org.bouncycastle.crypto.params.GOST3410KeyParameters;

class Utils {
    Utils() {
    }

    static CryptoServiceProperties getDefaultProperties(String string, DSAKeyParameters dSAKeyParameters, boolean bl) {
        return new DefaultServiceProperties(string, ConstraintUtils.bitsOfSecurityFor(dSAKeyParameters.getParameters().getP()), dSAKeyParameters, Utils.getPurpose(bl));
    }

    static CryptoServiceProperties getDefaultProperties(String string, GOST3410KeyParameters gOST3410KeyParameters, boolean bl) {
        return new DefaultServiceProperties(string, ConstraintUtils.bitsOfSecurityFor(gOST3410KeyParameters.getParameters().getP()), gOST3410KeyParameters, Utils.getPurpose(bl));
    }

    static CryptoServiceProperties getDefaultProperties(String string, ECKeyParameters eCKeyParameters, boolean bl) {
        return new DefaultServiceProperties(string, ConstraintUtils.bitsOfSecurityFor(eCKeyParameters.getParameters().getCurve()), eCKeyParameters, Utils.getPurpose(bl));
    }

    static CryptoServiceProperties getDefaultProperties(String string, int n, CipherParameters cipherParameters, boolean bl) {
        return new DefaultServiceProperties(string, n, cipherParameters, Utils.getPurpose(bl));
    }

    static CryptoServicePurpose getPurpose(boolean bl) {
        return bl ? CryptoServicePurpose.SIGNING : CryptoServicePurpose.VERIFYING;
    }
}

