/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.compression;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import pl.skidam.automodpack_core.protocol.compression.CompressionCodec;

public class ZstdCompression
implements CompressionCodec {
    private static final MethodHandle compressMethodHandle;
    private static final MethodHandle decompressMethodHandle;

    @Override
    public byte[] compress(byte[] input) throws IOException {
        try {
            return compressMethodHandle.invokeExact(input);
        }
        catch (Throwable e) {
            throw new IOException("Zstd compression failed", e);
        }
    }

    @Override
    public byte[] decompress(byte[] compressed, int originalLength) throws IOException {
        try {
            byte[] decompressed = decompressMethodHandle.invokeExact(compressed, originalLength);
            if (decompressed.length != originalLength) {
                throw new IOException("Unexpected decompressed length: " + decompressed.length + " (expected " + originalLength + ")");
            }
            return decompressed;
        }
        catch (Throwable e) {
            throw new IOException("Zstd decompression failed", e);
        }
    }

    @Override
    public byte getCompressionType() {
        return 1;
    }

    static {
        try {
            Path tempJar = Files.createTempFile("zstd-jni-", ".jar", new FileAttribute[0]);
            try (InputStream in = ZstdCompression.class.getResourceAsStream("/META-INF/jarjar/zstd-jni.jar");){
                if (in == null) {
                    throw new IOException("Failed to open stream to embedded /META-INF/jarjar/zstd-jni.jar");
                }
                Files.copy(in, tempJar, StandardCopyOption.REPLACE_EXISTING);
            }
            tempJar.toFile().deleteOnExit();
            URLClassLoader loader = new URLClassLoader(new URL[]{tempJar.toUri().toURL()}, ZstdCompression.class.getClassLoader());
            Class<?> zstdClass = Class.forName("com.github.luben.zstd.Zstd", true, loader);
            Method compressMethod = zstdClass.getMethod("compress", byte[].class);
            Method decompressMethod = zstdClass.getMethod("decompress", byte[].class, Integer.TYPE);
            compressMethodHandle = MethodHandles.lookup().unreflect(compressMethod);
            decompressMethodHandle = MethodHandles.lookup().unreflect(decompressMethod);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize embedded zstd-jni", e);
        }
    }
}

