/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.cms;

import am_libs.org.bouncycastle.asn1.ASN1OctetString;
import am_libs.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import am_libs.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import am_libs.org.bouncycastle.asn1.cms.RecipientIdentifier;
import am_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import am_libs.org.bouncycastle.cms.CMSException;
import am_libs.org.bouncycastle.cms.CMSSecureReadable;
import am_libs.org.bouncycastle.cms.KeyTransRecipient;
import am_libs.org.bouncycastle.cms.KeyTransRecipientId;
import am_libs.org.bouncycastle.cms.Recipient;
import am_libs.org.bouncycastle.cms.RecipientInformation;
import am_libs.org.bouncycastle.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

