/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import pl.skidam.automodpack_core.protocol.compression.CompressionCodec;

public class CompressionEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final CompressionCodec codec;

    public CompressionEncoder(CompressionCodec codec) {
        if (codec == null) {
            throw new IllegalArgumentException("Compression codec cannot be null");
        }
        this.codec = codec;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        byte[] input = new byte[msg.readableBytes()];
        msg.readBytes(input);
        byte[] compressed = this.codec.compress(input);
        out.writeInt(compressed.length);
        out.writeInt(input.length);
        out.writeBytes(compressed);
    }

    public CompressionCodec getCodec() {
        return this.codec;
    }
}

