/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.compression;

import pl.skidam.automodpack_core.protocol.compression.CompressionCodec;
import pl.skidam.automodpack_core.protocol.compression.GzipCompression;
import pl.skidam.automodpack_core.protocol.compression.NoneCompression;
import pl.skidam.automodpack_core.protocol.compression.ZstdCompression;

public class CompressionFactory {
    public static CompressionCodec getCodec(byte compressionType) {
        return switch (compressionType) {
            case 1 -> Zstd.CODEC;
            case 2 -> Gzip.CODEC;
            case 0 -> None.CODEC;
            default -> throw new IllegalArgumentException("Unsupported compression type: " + compressionType);
        };
    }

    private static class Zstd {
        private static final ZstdCompression CODEC = new ZstdCompression();

        private Zstd() {
        }
    }

    private static class Gzip {
        private static final GzipCompression CODEC = new GzipCompression();

        private Gzip() {
        }
    }

    private static class None {
        private static final NoneCompression CODEC = new NoneCompression();

        private None() {
        }
    }
}

