/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.asn1.cmp;

import am_libs.org.bouncycastle.asn1.ASN1Object;
import am_libs.org.bouncycastle.asn1.ASN1Primitive;
import am_libs.org.bouncycastle.asn1.ASN1Sequence;
import am_libs.org.bouncycastle.asn1.DERSequence;
import am_libs.org.bouncycastle.asn1.x509.CertificateList;

public class CRLAnnContent
extends ASN1Object {
    private final ASN1Sequence content;

    private CRLAnnContent(ASN1Sequence aSN1Sequence) {
        this.content = aSN1Sequence;
    }

    public CRLAnnContent(CertificateList certificateList) {
        this.content = new DERSequence(certificateList);
    }

    public static CRLAnnContent getInstance(Object object) {
        if (object instanceof CRLAnnContent) {
            return (CRLAnnContent)object;
        }
        if (object != null) {
            return new CRLAnnContent(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CertificateList[] getCertificateLists() {
        CertificateList[] certificateListArray = new CertificateList[this.content.size()];
        for (int i = 0; i != certificateListArray.length; ++i) {
            certificateListArray[i] = CertificateList.getInstance(this.content.getObjectAt(i));
        }
        return certificateListArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.content;
    }
}

