/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.utils.CustomFileUtils;

public class WildCards {
    private final Map<String, Path> wildcardMatches = new HashMap<String, Path>();
    private final List<String> whiteListRules = new ArrayList<String>();
    private final List<String> blackListRules = new ArrayList<String>();

    public boolean fileMatches(String path, Path file) {
        return this.wildcardMatches.containsKey(path) || this.wildcardMatches.containsValue(file);
    }

    public Map<String, Path> getWildcardMatches() {
        return this.wildcardMatches;
    }

    public void separateRules(List<String> rules) {
        for (String rule : rules) {
            if (rule.startsWith("!")) {
                this.blackListRules.add(rule.substring(1));
                continue;
            }
            this.whiteListRules.add(rule);
        }
    }

    public WildCards(List<String> rules, Set<Path> startDirectories) {
        try {
            this.separateRules(rules);
            Map<String, List<String>> composedWhiteRules = this.composeRules(this.whiteListRules);
            Map<String, List<String>> composedBlackRules = this.composeRules(this.blackListRules);
            for (Path startDirectory : startDirectories) {
                try (Stream<Path> paths = Files.walk(startDirectory, new FileVisitOption[0]);){
                    paths.forEach(node -> this.matchWhiteRules((Path)node, startDirectory, composedWhiteRules));
                }
                this.matchBlackRules(startDirectory, composedBlackRules);
            }
        }
        catch (IOException e) {
            GlobalVariables.LOGGER.error("Failed to walk directories: {}", startDirectories, (Object)e);
        }
    }

    public void matchWhiteRules(Path node, Path startDirectory, Map<String, List<String>> composedWhiteRules) {
        if (!node.toFile().isFile()) {
            return;
        }
        String formattedPath = this.matchesRules(node, startDirectory, composedWhiteRules);
        if (formattedPath != null) {
            this.wildcardMatches.put(formattedPath, node);
        }
    }

    public void matchBlackRules(Path startDirectory, Map<String, List<String>> composedBlackRules) {
        HashSet<String> pathsToRemove = new HashSet<String>();
        for (Path node : this.getWildcardMatches().values()) {
            String formattedPath;
            if (!node.toFile().isFile() || (formattedPath = this.matchesRules(node, startDirectory, composedBlackRules)) == null) continue;
            pathsToRemove.add(formattedPath);
        }
        for (String path : pathsToRemove) {
            this.wildcardMatches.remove(path);
        }
    }

    private String matchesRules(Path node, Path startDirectory, Map<String, List<String>> rules) {
        String formattedPath = CustomFileUtils.formatPath(node, startDirectory);
        int lastSlashIndex = formattedPath.lastIndexOf("/");
        if (lastSlashIndex == -1) {
            return null;
        }
        String directoryPart = formattedPath.substring(0, lastSlashIndex);
        String fileNamePart = formattedPath.substring(lastSlashIndex);
        for (Map.Entry<String, List<String>> entry : rules.entrySet()) {
            String ruleDirectory = entry.getKey();
            List<String> rulePaths = entry.getValue();
            if (!directoryPart.startsWith(ruleDirectory)) continue;
            boolean directoryMatch = directoryPart.equals(ruleDirectory);
            for (String rulePath : rulePaths) {
                if (rulePath.equals("/**")) {
                    return formattedPath;
                }
                if (rulePath.equals("/*") || rulePath.equals("/")) {
                    if (!directoryMatch) continue;
                    return formattedPath;
                }
                if (rulePath.contains("*")) {
                    String partOne;
                    if (!directoryMatch) continue;
                    if (rulePath.indexOf("*") != rulePath.lastIndexOf("*")) {
                        GlobalVariables.LOGGER.error("Only one * in the rule path is allowed: {}", (Object)rulePath);
                        continue;
                    }
                    String[] ruleParts = rulePath.split("\\*");
                    String partTwo = "";
                    if (ruleParts.length == 1) {
                        partOne = ruleParts[0];
                    } else if (ruleParts.length == 2) {
                        partOne = ruleParts[0];
                        partTwo = ruleParts[1];
                    } else {
                        GlobalVariables.LOGGER.error("Invalid rule path: {}", (Object)rulePath);
                        continue;
                    }
                    if (!fileNamePart.startsWith(partOne) || !fileNamePart.endsWith(partTwo)) continue;
                    return formattedPath;
                }
                if (!rulePath.equals(fileNamePart)) continue;
                return formattedPath;
            }
        }
        return null;
    }

    public Map<String, List<String>> composeRules(List<String> rules) {
        HashMap<String, List<String>> directoryRulePathsMap = new HashMap<String, List<String>>(rules.size());
        for (String rule : rules) {
            int lastSlashIndex = rule.lastIndexOf("/");
            if (lastSlashIndex == -1) continue;
            String directoryPart = rule.substring(0, lastSlashIndex);
            if (directoryPart.contains("*")) {
                GlobalVariables.LOGGER.error("Wildcards in directory part are not supported yet: {}", (Object)directoryPart);
                continue;
            }
            String rulePath = rule.substring(lastSlashIndex);
            directoryRulePathsMap.computeIfAbsent(directoryPart, k -> new ArrayList()).add(rulePath);
        }
        return directoryRulePathsMap;
    }
}

