/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.apache.hc.core5.http.impl;

import am_libs.org.apache.hc.core5.http.protocol.HttpProcessor;
import am_libs.org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import am_libs.org.apache.hc.core5.http.protocol.RequestConformance;
import am_libs.org.apache.hc.core5.http.protocol.RequestConnControl;
import am_libs.org.apache.hc.core5.http.protocol.RequestContent;
import am_libs.org.apache.hc.core5.http.protocol.RequestExpectContinue;
import am_libs.org.apache.hc.core5.http.protocol.RequestTargetHost;
import am_libs.org.apache.hc.core5.http.protocol.RequestUserAgent;
import am_libs.org.apache.hc.core5.http.protocol.RequestValidateHost;
import am_libs.org.apache.hc.core5.http.protocol.ResponseConformance;
import am_libs.org.apache.hc.core5.http.protocol.ResponseConnControl;
import am_libs.org.apache.hc.core5.http.protocol.ResponseContent;
import am_libs.org.apache.hc.core5.http.protocol.ResponseDate;
import am_libs.org.apache.hc.core5.http.protocol.ResponseServer;
import am_libs.org.apache.hc.core5.util.TextUtils;
import am_libs.org.apache.hc.core5.util.VersionInfo;

public final class HttpProcessors {
    private static final String SOFTWARE = "Apache-HttpCore";

    public static HttpProcessorBuilder customServer(String serverInfo) {
        return HttpProcessorBuilder.create().addAll(ResponseConformance.INSTANCE, ResponseDate.INSTANCE, new ResponseServer(!TextUtils.isBlank(serverInfo) ? serverInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "am_libs.org.apache.hc.core5", HttpProcessors.class)), ResponseContent.INSTANCE, ResponseConnControl.INSTANCE).addAll(RequestValidateHost.INSTANCE, RequestConformance.INSTANCE);
    }

    public static HttpProcessor server(String serverInfo) {
        return HttpProcessors.customServer(serverInfo).build();
    }

    public static HttpProcessor server() {
        return HttpProcessors.customServer(null).build();
    }

    public static HttpProcessorBuilder customClient(String agentInfo) {
        return HttpProcessorBuilder.create().addAll(RequestTargetHost.INSTANCE, RequestContent.INSTANCE, RequestConnControl.INSTANCE, new RequestUserAgent(!TextUtils.isBlank(agentInfo) ? agentInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "am_libs.org.apache.hc.core5", HttpProcessors.class)), RequestExpectContinue.INSTANCE);
    }

    public static HttpProcessor client(String agentInfo) {
        return HttpProcessors.customClient(agentInfo).build();
    }

    public static HttpProcessor client() {
        return HttpProcessors.customClient(null).build();
    }
}

