/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.apache.hc.core5.http.impl.bootstrap;

import am_libs.org.apache.hc.core5.annotation.Internal;
import am_libs.org.apache.hc.core5.concurrent.DefaultThreadFactory;
import am_libs.org.apache.hc.core5.concurrent.FutureCallback;
import am_libs.org.apache.hc.core5.function.Callback;
import am_libs.org.apache.hc.core5.function.Decorator;
import am_libs.org.apache.hc.core5.function.Resolver;
import am_libs.org.apache.hc.core5.http.HttpHost;
import am_libs.org.apache.hc.core5.http.HttpRequest;
import am_libs.org.apache.hc.core5.http.ProtocolException;
import am_libs.org.apache.hc.core5.http.impl.DefaultAddressResolver;
import am_libs.org.apache.hc.core5.http.impl.bootstrap.AbstractConnectionInitiatorBase;
import am_libs.org.apache.hc.core5.io.CloseMode;
import am_libs.org.apache.hc.core5.net.URIAuthority;
import am_libs.org.apache.hc.core5.reactor.ConnectionInitiator;
import am_libs.org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import am_libs.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import am_libs.org.apache.hc.core5.reactor.IOReactorConfig;
import am_libs.org.apache.hc.core5.reactor.IOReactorService;
import am_libs.org.apache.hc.core5.reactor.IOReactorStatus;
import am_libs.org.apache.hc.core5.reactor.IOSession;
import am_libs.org.apache.hc.core5.reactor.IOSessionListener;
import am_libs.org.apache.hc.core5.util.Args;
import am_libs.org.apache.hc.core5.util.TimeValue;
import am_libs.org.apache.hc.core5.util.Timeout;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;

public class AsyncRequester
extends AbstractConnectionInitiatorBase
implements IOReactorService {
    private final DefaultConnectingIOReactor ioReactor;
    private final Resolver<HttpHost, InetSocketAddress> addressResolver;

    @Internal
    public AsyncRequester(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, Decorator<IOSession> ioSessionDecorator, Callback<Exception> exceptionCallback, IOSessionListener sessionListener, Callback<IOSession> sessionShutdownCallback, Resolver<HttpHost, InetSocketAddress> addressResolver) {
        this.ioReactor = new DefaultConnectingIOReactor(eventHandlerFactory, ioReactorConfig, new DefaultThreadFactory("requester-dispatch", true), ioSessionDecorator, exceptionCallback, sessionListener, sessionShutdownCallback);
        this.addressResolver = addressResolver != null ? addressResolver : DefaultAddressResolver.INSTANCE;
    }

    @Override
    ConnectionInitiator getIOReactor() {
        return this.ioReactor;
    }

    public Future<IOSession> requestSession(HttpHost host, Timeout timeout, Object attachment, FutureCallback<IOSession> callback) {
        Args.notNull(host, "Host");
        Args.notNull(timeout, "Timeout");
        return this.connect(host, this.addressResolver.resolve(host), null, timeout, attachment, callback);
    }

    @Override
    public void start() {
        this.ioReactor.start();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    public void initiateShutdown() {
        this.ioReactor.initiateShutdown();
    }

    @Override
    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        this.ioReactor.awaitShutdown(waitTime);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioReactor.close(closeMode);
    }

    @Override
    public void close() throws IOException {
        this.ioReactor.close();
    }

    @Internal
    protected static HttpHost defaultTarget(HttpRequest request) throws ProtocolException {
        String scheme = request.getScheme();
        URIAuthority authority = request.getAuthority();
        if (authority == null) {
            throw new ProtocolException("Request authority not specified");
        }
        return new HttpHost(scheme, authority);
    }
}

