/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.apache.hc.core5.http2.nio.pool;

import am_libs.org.apache.hc.core5.annotation.Contract;
import am_libs.org.apache.hc.core5.annotation.ThreadingBehavior;
import am_libs.org.apache.hc.core5.concurrent.CallbackContribution;
import am_libs.org.apache.hc.core5.concurrent.FutureCallback;
import am_libs.org.apache.hc.core5.function.Callback;
import am_libs.org.apache.hc.core5.function.Resolver;
import am_libs.org.apache.hc.core5.http.HttpHost;
import am_libs.org.apache.hc.core5.http.URIScheme;
import am_libs.org.apache.hc.core5.http.impl.DefaultAddressResolver;
import am_libs.org.apache.hc.core5.http.nio.command.ShutdownCommand;
import am_libs.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import am_libs.org.apache.hc.core5.http2.nio.command.PingCommand;
import am_libs.org.apache.hc.core5.http2.nio.support.BasicPingHandler;
import am_libs.org.apache.hc.core5.io.CloseMode;
import am_libs.org.apache.hc.core5.reactor.AbstractIOSessionPool;
import am_libs.org.apache.hc.core5.reactor.Command;
import am_libs.org.apache.hc.core5.reactor.ConnectionInitiator;
import am_libs.org.apache.hc.core5.reactor.IOSession;
import am_libs.org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import am_libs.org.apache.hc.core5.util.Args;
import am_libs.org.apache.hc.core5.util.TimeValue;
import am_libs.org.apache.hc.core5.util.Timeout;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;

@Contract(threading=ThreadingBehavior.SAFE)
public final class H2ConnPool
extends AbstractIOSessionPool<HttpHost> {
    private final ConnectionInitiator connectionInitiator;
    private final Resolver<HttpHost, InetSocketAddress> addressResolver;
    private final TlsStrategy tlsStrategy;
    private volatile TimeValue validateAfterInactivity = TimeValue.NEG_ONE_MILLISECOND;

    public H2ConnPool(ConnectionInitiator connectionInitiator, Resolver<HttpHost, InetSocketAddress> addressResolver, TlsStrategy tlsStrategy) {
        this.connectionInitiator = Args.notNull(connectionInitiator, "Connection initiator");
        this.addressResolver = addressResolver != null ? addressResolver : DefaultAddressResolver.INSTANCE;
        this.tlsStrategy = tlsStrategy;
    }

    public TimeValue getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public void setValidateAfterInactivity(TimeValue timeValue) {
        this.validateAfterInactivity = timeValue;
    }

    @Override
    protected void closeSession(IOSession ioSession, CloseMode closeMode) {
        if (closeMode == CloseMode.GRACEFUL) {
            ioSession.enqueue(ShutdownCommand.GRACEFUL, Command.Priority.NORMAL);
        } else {
            ioSession.close(closeMode);
        }
    }

    @Override
    protected Future<IOSession> connectSession(final HttpHost namedEndpoint, final Timeout connectTimeout, final FutureCallback<IOSession> callback) {
        InetSocketAddress remoteAddress = this.addressResolver.resolve(namedEndpoint);
        return this.connectionInitiator.connect(namedEndpoint, remoteAddress, null, connectTimeout, null, (FutureCallback<IOSession>)new CallbackContribution<IOSession>(callback){

            @Override
            public void completed(final IOSession ioSession) {
                if (H2ConnPool.this.tlsStrategy != null && URIScheme.HTTPS.same(namedEndpoint.getSchemeName()) && ioSession instanceof TransportSecurityLayer) {
                    H2ConnPool.this.tlsStrategy.upgrade((TransportSecurityLayer)((Object)ioSession), namedEndpoint, null, connectTimeout, (FutureCallback<TransportSecurityLayer>)new CallbackContribution<TransportSecurityLayer>(callback){

                        @Override
                        public void completed(TransportSecurityLayer transportSecurityLayer) {
                            callback.completed(ioSession);
                        }
                    });
                    ioSession.setSocketTimeout(connectTimeout);
                } else {
                    callback.completed(ioSession);
                }
            }
        });
    }

    @Override
    protected void validateSession(IOSession ioSession, Callback<Boolean> callback) {
        if (ioSession.isOpen()) {
            long lastAccessTime;
            long deadline;
            TimeValue timeValue = this.validateAfterInactivity;
            if (TimeValue.isNonNegative(timeValue) && (deadline = (lastAccessTime = Math.min(ioSession.getLastReadTime(), ioSession.getLastWriteTime())) + timeValue.toMilliseconds()) <= System.currentTimeMillis()) {
                Timeout socketTimeoutMillis = ioSession.getSocketTimeout();
                ioSession.enqueue(new PingCommand(new BasicPingHandler(result -> {
                    ioSession.setSocketTimeout(socketTimeoutMillis);
                    callback.execute((Boolean)result);
                })), Command.Priority.NORMAL);
                return;
            }
            callback.execute(true);
        } else {
            callback.execute(false);
        }
    }
}

