/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.operator.bc;

import am_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import am_libs.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import am_libs.org.bouncycastle.crypto.ExtendedDigest;
import am_libs.org.bouncycastle.crypto.Signer;
import am_libs.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import am_libs.org.bouncycastle.crypto.signers.DSADigestSigner;
import am_libs.org.bouncycastle.crypto.signers.DSASigner;
import am_libs.org.bouncycastle.crypto.util.PublicKeyFactory;
import am_libs.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import am_libs.org.bouncycastle.operator.OperatorCreationException;
import am_libs.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import java.io.IOException;

public class BcDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcDSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new DSADigestSigner(new DSASigner(), extendedDigest);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

