/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.pqc.crypto.lms;

import am_libs.org.bouncycastle.crypto.KeyGenerationParameters;
import am_libs.org.bouncycastle.pqc.crypto.lms.LMSParameters;
import am_libs.org.bouncycastle.pqc.crypto.lms.LmsUtils;
import java.security.SecureRandom;

public class HSSKeyGenerationParameters
extends KeyGenerationParameters {
    private final LMSParameters[] lmsParameters;

    public HSSKeyGenerationParameters(LMSParameters[] lMSParametersArray, SecureRandom secureRandom) {
        super(secureRandom, LmsUtils.calculateStrength(lMSParametersArray[0]));
        if (lMSParametersArray.length == 0 || lMSParametersArray.length > 8) {
            throw new IllegalArgumentException("lmsParameters length should be between 1 and 8 inclusive");
        }
        this.lmsParameters = lMSParametersArray;
    }

    public int getDepth() {
        return this.lmsParameters.length;
    }

    public LMSParameters[] getLmsParameters() {
        return this.lmsParameters;
    }
}

