/*
 * Decompiled with CFR 0.152.
 */
package com.pandaismyname1.emiletsdocompat.vinery;

import com.pandaismyname1.emiletsdocompat.MockRecipeIdGenerator;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.satisfy.vinery.core.recipe.FermentationBarrelRecipe;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.platform.PlatformHelper;

public class FermentationRecipe
extends BasicEmiRecipe {
    public static final class_2960 TEXTURE = class_2960.method_60655((String)"vinery", (String)"textures/gui/fermentation_barrel_gui.png");
    protected static final Supplier<class_5455> REGISTRY_ACCESS = (Supplier)EnvExecutor.getEnvSpecific(() -> () -> () -> GameInstance.getClient().field_1724.method_37908().method_30349(), () -> () -> () -> GameInstance.getServer().method_30611());
    private final String juiceType;
    private final int fluidLevel;
    private final boolean requiresBottle;

    public FermentationRecipe(EmiRecipeCategory category, FermentationBarrelRecipe recipe) {
        super(category, MockRecipeIdGenerator.generateRecipeId(), 70, 18);
        this.juiceType = recipe.getJuiceData().type();
        this.fluidLevel = recipe.getJuiceData().amount();
        this.requiresBottle = recipe.isWineBottleRequired();
        class_2371 ingredients = recipe.method_8117();
        for (class_1856 ingredient : ingredients) {
            this.inputs.add(EmiIngredient.of((class_1856)ingredient));
        }
        this.outputs.add(EmiStack.of((class_1799)recipe.method_8110((class_7225.class_7874)REGISTRY_ACCESS.get())));
    }

    private class_2561 getFluidTooltip(String juiceType, int fluidLevel) {
        int maxFluidLevel = PlatformHelper.getMaxFluidLevel();
        double percentage = (double)fluidLevel / (double)maxFluidLevel * 100.0;
        String percentageStr = String.format("%.2f", percentage);
        if (juiceType.startsWith("red")) {
            String region = juiceType.substring(4);
            return class_2561.method_43469((String)("tooltip.vinery.fermentation_barrel.red_" + region + "_juice_with_percentage"), (Object[])new Object[]{percentageStr});
        }
        if (juiceType.startsWith("white")) {
            String region = juiceType.substring(6);
            return class_2561.method_43469((String)("tooltip.vinery.fermentation_barrel.white_" + region + "_juice_with_percentage"), (Object[])new Object[]{percentageStr});
        }
        return juiceType.equals("apple") ? class_2561.method_43469((String)"tooltip.vinery.fermentation_barrel.apple_juice_with_percentage", (Object[])new Object[]{percentageStr}) : class_2561.method_43471((String)"tooltip.vinery.fermentation_barrel.empty");
    }

    public void addWidgets(WidgetHolder widgets) {
        SlotWidget s;
        widgets.addTexture(TEXTURE, 0, 0, 124, 72, 26, 6);
        widgets.addAnimatedTexture(TEXTURE, 96, 14, 10, 28, 176, 0, 20000, false, true, false);
        widgets.addAnimatedTexture(TEXTURE, 56, 38, 20, 4, 176, 37, 30000, true, false, true);
        ArrayList<class_2561> ttList = new ArrayList<class_2561>();
        ttList.add(this.getFluidTooltip(this.juiceType, this.fluidLevel));
        widgets.addTooltipText(ttList, 56, 38, 20, 4);
        if (!this.inputs.isEmpty()) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(0), 40, 51);
            s.drawBack(false);
        }
        if (this.inputs.size() > 1) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(1), 58, 51);
            s.drawBack(false);
        }
        if (this.inputs.size() > 2) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(2), 76, 51);
            s.drawBack(false);
        }
        if (this.requiresBottle) {
            s = widgets.addSlot(EmiIngredient.of((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)ObjectRegistry.WINE_BOTTLE.get()})), 96, 51);
            s.drawBack(false);
        }
        if (!this.outputs.isEmpty()) {
            s = widgets.addSlot((EmiIngredient)this.outputs.get(0), 76, 10);
            s.drawBack(false);
        }
    }

    public int getDisplayHeight() {
        return 75;
    }

    public int getDisplayWidth() {
        return 124;
    }
}

