/*
 * Decompiled with CFR 0.152.
 */
package com.pandaismyname1.emiletsdocompat.meadow.internal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pandaismyname1.emiletsdocompat.meadow.internal.Registry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FondueUseRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final ItemStack result;
    private final float cheeseCost;

    public FondueUseRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, float cheeseCost) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.cheeseCost = cheeseCost;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.ingredient);
        return list;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    @NotNull
    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public float getCheeseCost() {
        return this.cheeseCost;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Registry.FONDUE_USE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)Registry.FONDUE_USE.get();
    }

    public static class Serializer
    implements RecipeSerializer<FondueUseRecipe> {
        public FondueUseRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("ingredient"));
            JsonObject resultObj = json.getAsJsonObject("result");
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)resultObj);
            float cheeseCost = json.getAsJsonPrimitive("cheeseCost").getAsFloat();
            return new FondueUseRecipe(id, ingredient, result, cheeseCost);
        }

        public FondueUseRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack result = buf.m_130267_();
            float cheeseCost = buf.readFloat();
            return new FondueUseRecipe(id, ingredient, result, cheeseCost);
        }

        public void toNetwork(FriendlyByteBuf buf, FondueUseRecipe recipe) {
            recipe.ingredient.m_43923_(buf);
            buf.m_130055_(recipe.result);
            buf.writeFloat(recipe.cheeseCost);
        }
    }
}

