/*
 * Decompiled with CFR 0.152.
 */
package com.pandaismyname1.emiletsdocompat.vinery;

import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.satisfy.vinery.core.recipe.FermentationBarrelRecipe;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.platform.PlatformHelper;

public class FermentationRecipe
extends BasicEmiRecipe {
    public static final ResourceLocation TEXTURE = new ResourceLocation("vinery", "textures/gui/fermentation_barrel_gui.png");
    protected static final Supplier<RegistryAccess> REGISTRY_ACCESS = (Supplier)EnvExecutor.getEnvSpecific(() -> () -> () -> GameInstance.getClient().f_91074_.m_9236_().m_9598_(), () -> () -> () -> GameInstance.getServer().m_206579_());
    private final String juiceType;
    private final int fluidLevel;
    private final boolean requiresBottle;

    public FermentationRecipe(EmiRecipeCategory category, FermentationBarrelRecipe recipe) {
        super(category, recipe.m_6423_(), 70, 18);
        this.juiceType = recipe.getJuiceType();
        this.fluidLevel = recipe.getJuiceAmount();
        this.requiresBottle = recipe.isWineBottleRequired();
        NonNullList ingredients = recipe.m_7527_();
        for (Ingredient ingredient : ingredients) {
            this.inputs.add(EmiIngredient.of((Ingredient)ingredient));
        }
        this.outputs.add(EmiStack.of((ItemStack)recipe.m_8043_(REGISTRY_ACCESS.get())));
    }

    private Component getFluidTooltip(String juiceType, int fluidLevel) {
        int maxFluidLevel = PlatformHelper.getMaxFluidLevel();
        double percentage = (double)fluidLevel / (double)maxFluidLevel * 100.0;
        String percentageStr = String.format("%.2f", percentage);
        if (juiceType.startsWith("red")) {
            String region = juiceType.substring(4);
            return Component.m_237110_((String)("tooltip.vinery.fermentation_barrel.red_" + region + "_juice_with_percentage"), (Object[])new Object[]{percentageStr});
        }
        if (juiceType.startsWith("white")) {
            String region = juiceType.substring(6);
            return Component.m_237110_((String)("tooltip.vinery.fermentation_barrel.white_" + region + "_juice_with_percentage"), (Object[])new Object[]{percentageStr});
        }
        return juiceType.equals("apple") ? Component.m_237110_((String)"tooltip.vinery.fermentation_barrel.apple_juice_with_percentage", (Object[])new Object[]{percentageStr}) : Component.m_237115_((String)"tooltip.vinery.fermentation_barrel.empty");
    }

    public void addWidgets(WidgetHolder widgets) {
        SlotWidget s;
        widgets.addTexture(TEXTURE, 0, 0, 124, 72, 26, 6);
        widgets.addAnimatedTexture(TEXTURE, 96, 14, 10, 28, 176, 0, 20000, false, true, false);
        widgets.addAnimatedTexture(TEXTURE, 56, 38, 20, 4, 176, 37, 30000, true, false, true);
        ArrayList<Component> ttList = new ArrayList<Component>();
        ttList.add(this.getFluidTooltip(this.juiceType, this.fluidLevel));
        widgets.addTooltipText(ttList, 56, 38, 20, 4);
        if (!this.inputs.isEmpty()) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(0), 40, 51);
            s.drawBack(false);
        }
        if (this.inputs.size() > 1) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(1), 58, 51);
            s.drawBack(false);
        }
        if (this.inputs.size() > 2) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(2), 76, 51);
            s.drawBack(false);
        }
        if (this.requiresBottle) {
            s = widgets.addSlot(EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ObjectRegistry.WINE_BOTTLE.get()})), 96, 51);
            s.drawBack(false);
        }
        if (!this.outputs.isEmpty()) {
            s = widgets.addSlot((EmiIngredient)this.outputs.get(0), 76, 10);
            s.drawBack(false);
        }
    }

    public int getDisplayHeight() {
        return 75;
    }

    public int getDisplayWidth() {
        return 124;
    }
}

