/*
 * Decompiled with CFR 0.152.
 */
package com.pandaismyname1.emiletsdocompat.farm_and_charm;

import com.pandaismyname1.emiletsdocompat.MockRecipeIdGenerator;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class MincerRecipe
extends BasicEmiRecipe {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"farm_and_charm", (String)"textures/gui/mincer.png");
    protected static final Supplier<RegistryAccess> REGISTRY_ACCESS = (Supplier)EnvExecutor.getEnvSpecific(() -> () -> () -> GameInstance.getClient().player.level().registryAccess(), () -> () -> () -> GameInstance.getServer().registryAccess());

    public MincerRecipe(EmiRecipeCategory category, net.satisfy.farm_and_charm.core.recipe.MincerRecipe recipe) {
        super(category, MockRecipeIdGenerator.generateRecipeId(), 70, 18);
        NonNullList ingredients = recipe.getIngredients();
        for (Ingredient ingredient : ingredients) {
            this.inputs.add(EmiIngredient.of((Ingredient)ingredient));
        }
        this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)REGISTRY_ACCESS.get())));
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(TEXTURE, -1, -1, 124, 60, 25, 12);
        widgets.addFillingArrow(50, 21, 5000);
        if (this.inputs.size() > 0) {
            widgets.addSlot((EmiIngredient)this.inputs.get(0), 23, 21).drawBack(false);
        }
        if (this.outputs.size() > 0) {
            widgets.addSlot((EmiIngredient)this.outputs.get(0), 83, 21).drawBack(false);
        }
    }

    public int getDisplayHeight() {
        return 60;
    }

    public int getDisplayWidth() {
        return 124;
    }
}

