/*
 * Decompiled with CFR 0.152.
 */
package com.pandaismyname1.emiletsdocompat.meadow;

import com.pandaismyname1.emiletsdocompat.MockRecipeIdGenerator;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class CheeseFormRecipe
extends BasicEmiRecipe {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"meadow", (String)"textures/gui/cheese_form_gui.png");
    protected static final Supplier<RegistryAccess> REGISTRY_ACCESS = (Supplier)EnvExecutor.getEnvSpecific(() -> () -> () -> GameInstance.getClient().player.level().registryAccess(), () -> () -> () -> GameInstance.getServer().registryAccess());

    public CheeseFormRecipe(EmiRecipeCategory category, net.satisfy.meadow.core.recipes.CheeseFormRecipe recipe) {
        super(category, MockRecipeIdGenerator.generateRecipeId(), 70, 18);
        NonNullList ingredients = recipe.getIngredients();
        for (Ingredient ingredient : ingredients) {
            this.inputs.add(EmiIngredient.of((Ingredient)ingredient));
        }
        this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)REGISTRY_ACCESS.get())));
    }

    public void addWidgets(WidgetHolder widgets) {
        SlotWidget s;
        widgets.addTexture(TEXTURE, 0, 0, 124, 60, 26, 6);
        widgets.addAnimatedTexture(TEXTURE, 51, 30, 26, 10, 175, 4, 5000, true, false, false);
        widgets.addAnimatedTexture(TEXTURE, 50, 2, 26, 32, 175, 22, 5000, false, true, false);
        if (!this.inputs.isEmpty()) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(0), 6, 26);
            s.drawBack(false);
        }
        if (this.inputs.size() > 1) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(1), 24, 26);
            s.drawBack(false);
        }
        if (!this.outputs.isEmpty()) {
            s = widgets.addSlot((EmiIngredient)this.outputs.get(0), 96, 26);
            s.drawBack(false);
        }
    }

    public int getDisplayHeight() {
        return 60;
    }

    public int getDisplayWidth() {
        return 124;
    }
}

