/*
 * Decompiled with CFR 0.152.
 */
package com.pandaismyname1.emiletsdocompat.meadow;

import com.pandaismyname1.emiletsdocompat.MockRecipeIdGenerator;
import com.pandaismyname1.emiletsdocompat.meadow.internal.FondueFillRecipe;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.FillingArrowWidget;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextureWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.satisfy.meadow.core.registry.ObjectRegistry;

public class CustomFondueFillRecipe
extends BasicEmiRecipe {
    public static final ResourceLocation TOAST_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/sprites/toast/right_click.png");
    protected static final Supplier<RegistryAccess> REGISTRY_ACCESS = (Supplier)EnvExecutor.getEnvSpecific(() -> () -> () -> GameInstance.getClient().player.level().registryAccess(), () -> () -> () -> GameInstance.getServer().registryAccess());

    public CustomFondueFillRecipe(EmiRecipeCategory category, FondueFillRecipe recipe) {
        super(category, MockRecipeIdGenerator.generateRecipeId(), 70, 18);
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        for (Ingredient ingredient : ingredients) {
            this.inputs.add(EmiIngredient.of((Ingredient)ingredient));
        }
        this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)REGISTRY_ACCESS.get())));
    }

    public void addWidgets(WidgetHolder widgets) {
        SlotWidget input = widgets.addSlot((EmiIngredient)this.inputs.get(0), 5, 5);
        TextureWidget rightClick = widgets.addTexture(TOAST_TEXTURE, 25, 3, 20, 20, 0, 0, 20, 20, 20, 20);
        FillingArrowWidget arrow = widgets.addFillingArrow(45, 5, 5000);
        SlotWidget fondue = widgets.addSlot(EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ObjectRegistry.FONDUE.get()})), 75, 5);
    }

    public int getDisplayHeight() {
        return 28;
    }

    public int getDisplayWidth() {
        return 98;
    }
}

