/*
 * Decompiled with CFR 0.152.
 */
package com.pandaismyname1.emiletsdocompat.meadow.internal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pandaismyname1.emiletsdocompat.meadow.internal.Registry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FondueFillRecipe
implements Recipe<RecipeInput> {
    private final Ingredient ingredient;
    private final float fillAmount;

    public FondueFillRecipe(Ingredient ingredient, float fillAmount) {
        this.ingredient = ingredient;
        this.fillAmount = fillAmount;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.ingredient);
        return list;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    @NotNull
    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Registry.FONDUE_FILL_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)Registry.FONDUE_FILL.get();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public float getFillAmount() {
        return this.fillAmount;
    }

    public static class Serializer
    implements RecipeSerializer<FondueFillRecipe> {
        @NotNull
        public MapCodec<FondueFillRecipe> codec() {
            return RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(FondueFillRecipe::getIngredient), (App)Codec.FLOAT.fieldOf("fillAmount").forGetter(FondueFillRecipe::getFillAmount)).apply((Applicative)inst, FondueFillRecipe::new));
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, FondueFillRecipe> streamCodec() {
            return new StreamCodec<RegistryFriendlyByteBuf, FondueFillRecipe>(this){

                public void encode(RegistryFriendlyByteBuf buf, FondueFillRecipe recipe) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.getIngredient());
                    buf.writeFloat(recipe.getFillAmount());
                }

                @NotNull
                public FondueFillRecipe decode(RegistryFriendlyByteBuf buf) {
                    Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
                    float fill = buf.readFloat();
                    return new FondueFillRecipe(ingredient, fill);
                }
            };
        }
    }
}

