/*
 * Decompiled with CFR 0.152.
 */
package com.pandaismyname1.emiletsdocompat.vinery;

import com.pandaismyname1.emiletsdocompat.MockRecipeIdGenerator;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.satisfy.vinery.core.recipe.ApplePressMashingRecipe;

public class ApplePressingRecipe
extends BasicEmiRecipe {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"vinery", (String)"textures/gui/apple_press_gui.png");
    protected static final Supplier<RegistryAccess> REGISTRY_ACCESS = (Supplier)EnvExecutor.getEnvSpecific(() -> () -> () -> GameInstance.getClient().player.level().registryAccess(), () -> () -> () -> GameInstance.getServer().registryAccess());

    public ApplePressingRecipe(EmiRecipeCategory category, ApplePressMashingRecipe recipe) {
        super(category, MockRecipeIdGenerator.generateRecipeId(), 70, 18);
        NonNullList ingredients = recipe.getIngredients();
        for (Ingredient ingredient : ingredients) {
            this.inputs.add(EmiIngredient.of((Ingredient)ingredient));
        }
        this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)REGISTRY_ACCESS.get())));
    }

    public void addWidgets(WidgetHolder widgets) {
        SlotWidget s;
        widgets.addTexture(TEXTURE, 13, 3, 28, 54, 38, 15);
        widgets.addAnimatedTexture(TEXTURE, 15, 5, 25, 38, 176, 0, 5000, false, false, false);
        widgets.addFillingArrow(48, 25, 5000);
        widgets.addTexture(TEXTURE, 80, 25, 36, 18, 100, 49);
        if (!this.inputs.isEmpty()) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(0), 18, 21);
            s.drawBack(false);
        }
        if (!this.outputs.isEmpty()) {
            s = widgets.addSlot((EmiIngredient)this.outputs.get(0), 80, 25);
            s.drawBack(false);
        }
    }

    public int getDisplayHeight() {
        return 60;
    }

    public int getDisplayWidth() {
        return 124;
    }
}

