/*
 * Decompiled with CFR 0.152.
 */
package com.pandaismyname1.emiletsdocompat.vinery.internal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pandaismyname1.emiletsdocompat.vinery.internal.Registry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GrapeMashingRecipe
implements Recipe<RecipeInput> {
    private final Ingredient ingredient;
    private final ItemStack result;

    public GrapeMashingRecipe(Ingredient ingredient, ItemStack result) {
        this.ingredient = ingredient;
        this.result = result;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.ingredient);
        return list;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    @NotNull
    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Registry.GRAPE_MASHING_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)Registry.GRAPE_MASHING.get();
    }

    public static class Serializer
    implements RecipeSerializer<GrapeMashingRecipe> {
        @NotNull
        public MapCodec<GrapeMashingRecipe> codec() {
            return RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(GrapeMashingRecipe::getIngredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(GrapeMashingRecipe::getResult)).apply((Applicative)inst, GrapeMashingRecipe::new));
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, GrapeMashingRecipe> streamCodec() {
            return new StreamCodec<RegistryFriendlyByteBuf, GrapeMashingRecipe>(this){

                public void encode(RegistryFriendlyByteBuf buf, GrapeMashingRecipe recipe) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.getIngredient());
                    ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getResult());
                }

                @NotNull
                public GrapeMashingRecipe decode(RegistryFriendlyByteBuf buf) {
                    return new GrapeMashingRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf));
                }
            };
        }
    }
}

